/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.SwapMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

class SwapMetricsSupplier
implements MeasurementSupplier {
    final Gauge<Double> swapUsage;
    final Gauge<Long> pageIn;
    final Gauge<Long> pageOut;
    final String nodeId;

    @Inject
    SwapMetricsSupplier(final SystemInfo sysInfo, @NodeId String nodeId) {
        this.nodeId = nodeId;
        this.swapUsage = Metrics.newGauge(SwapMetricsSupplier.class, (String)"usage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getSwapUsage().getUsedPercent();
                }
                catch (UnsupportedOperationException e) {
                    return -1.0;
                }
            }
        });
        this.pageIn = Metrics.newGauge(SwapMetricsSupplier.class, (String)"pageIn", (Gauge)new Gauge<Long>(){

            public Long value() {
                try {
                    return sysInfo.getSwapUsage().getPageIn();
                }
                catch (UnsupportedOperationException e) {
                    return 0L;
                }
            }
        });
        this.pageOut = Metrics.newGauge(SwapMetricsSupplier.class, (String)"pageOut", (Gauge)new Gauge<Long>(){

            public Long value() {
                try {
                    return sysInfo.getSwapUsage().getPageOut();
                }
                catch (UnsupportedOperationException e) {
                    return 0L;
                }
            }
        });
    }

    @Override
    public String getId() {
        return "swap";
    }

    @Override
    public String getName() {
        return "Swap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        if (!Bootstrap.isServer()) {
            return Collections.emptyList();
        }
        if (!PluginSetting.get().isSwapMeasurementsEnabled()) {
            return Collections.emptyList();
        }
        long timestamp = System.currentTimeMillis();
        ImmutableList immutableList = ImmutableList.builder().add((Object)MeasurementDataBuilder.of(timestamp, this.nodeId, SwapMetricGroup.USAGE.getMetricName(), (Number)this.swapUsage.value())).build();
        return immutableList;
    }
}

