/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.NetworkMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.NetworkAdapterInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

public class NetworkMetricsSupplier
implements MeasurementSupplier {
    final String nodeId;
    final Gauge<Long> txBytes;
    final Gauge<Long> rxBytes;
    private long previousTxBytes = -1L;
    private long previousRxBytes = -1L;

    @Inject
    NetworkMetricsSupplier(final SystemInfo sysInfo, @NodeId String nodeId) {
        this.nodeId = nodeId;
        this.txBytes = Metrics.newGauge(NetworkMetricsSupplier.class, (String)"txBytes", (Gauge)new Gauge<Long>(){

            public Long value() {
                try {
                    List<NetworkAdapterInfo> all = sysInfo.getAllNetworkAdapters();
                    long total = 0L;
                    for (NetworkAdapterInfo each : all) {
                        total += sysInfo.getNetworkAdapterStats(each.getName()).getTxBytes();
                    }
                    long tx = 0L;
                    if (NetworkMetricsSupplier.this.previousTxBytes >= 0L) {
                        tx = total - NetworkMetricsSupplier.this.previousTxBytes;
                    }
                    NetworkMetricsSupplier.this.previousTxBytes = total;
                    return tx;
                }
                catch (UnsupportedOperationException e) {
                    return 0L;
                }
            }
        });
        this.rxBytes = Metrics.newGauge(NetworkMetricsSupplier.class, (String)"rxBytes", (Gauge)new Gauge<Long>(){

            public Long value() {
                try {
                    List<NetworkAdapterInfo> all = sysInfo.getAllNetworkAdapters();
                    long total = 0L;
                    for (NetworkAdapterInfo each : all) {
                        total += sysInfo.getNetworkAdapterStats(each.getName()).getRxBytes();
                    }
                    long rx = 0L;
                    if (NetworkMetricsSupplier.this.previousRxBytes >= 0L) {
                        rx = total - NetworkMetricsSupplier.this.previousRxBytes;
                    }
                    NetworkMetricsSupplier.this.previousRxBytes = total;
                    return rx;
                }
                catch (UnsupportedOperationException e) {
                    return 0L;
                }
            }
        });
    }

    @Override
    public String getId() {
        return "network";
    }

    @Override
    public String getName() {
        return "Network";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        if (!Bootstrap.isServer()) {
            return Collections.emptyList();
        }
        if (!PluginSetting.get().isNetworkMeasurementsEnabled()) {
            return Collections.emptyList();
        }
        long timestamp = System.currentTimeMillis();
        long tx = (Long)this.txBytes.value();
        long rx = (Long)this.rxBytes.value();
        ArrayList list = Lists.newArrayList();
        if (tx > 0L) {
            list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, NetworkMetricGroup.TXBYTES.getMetricName(), tx));
        }
        if (rx > 0L) {
            list.add(MeasurementDataBuilder.of(timestamp, this.nodeId, NetworkMetricGroup.RXBYTES.getMetricName(), rx));
        }
        ArrayList arrayList = list;
        return arrayList;
    }
}

