/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.MemoryMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

class MemoryMetricsSupplier
implements MeasurementSupplier {
    final Gauge<Double> memUsage;
    final Gauge<Long> memUsedBytes;
    final Gauge<Long> memFreeBytes;
    final String nodeId;

    @Inject
    MemoryMetricsSupplier(final SystemInfo sysInfo, @NodeId String nodeId) {
        this.nodeId = nodeId;
        this.memFreeBytes = Metrics.newGauge(MemoryMetricsSupplier.class, (String)"freeBytes", (Gauge)new Gauge<Long>(){

            public Long value() {
                try {
                    return sysInfo.getMemoryUsage().getFree();
                }
                catch (UnsupportedOperationException e) {
                    return 0L;
                }
            }
        });
        this.memUsedBytes = Metrics.newGauge(MemoryMetricsSupplier.class, (String)"usedBytes", (Gauge)new Gauge<Long>(){

            public Long value() {
                try {
                    return sysInfo.getMemoryUsage().getUsed();
                }
                catch (UnsupportedOperationException e) {
                    return 0L;
                }
            }
        });
        this.memUsage = Metrics.newGauge(MemoryMetricsSupplier.class, (String)"memUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getMemoryUsage().getUsedPercent();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
    }

    @Override
    public String getId() {
        return "mem";
    }

    @Override
    public String getName() {
        return "Physical Memory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        block3: {
            if (PluginSetting.get().isMemoryMeasurementsEnabled()) break block3;
            List<MeasurementData> list = Collections.emptyList();
            return list;
        }
        long timestamp = System.currentTimeMillis();
        ImmutableList immutableList = ImmutableList.of((Object)MeasurementDataBuilder.of(timestamp, this.nodeId, MemoryMetricGroup.USAGE.getMetricName(), (Number)this.memUsage.value()));
        return immutableList;
    }
}

