/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.JvmMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.util.RatioGauge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

class JvmMetricsSupplier
implements MeasurementSupplier {
    Gauge<Double> memoryUsage;
    Gauge<Double> heapUsage;
    Gauge<Double> nonHeapUsage;
    Gauge<Double> averageGcTime;
    Gauge<Integer> threadCount;
    Gauge<Long> gcRuns;
    Gauge<Long> gcTime;
    Gauge<Double> fileDescriptorUsage;
    final String nodeId;
    private Long previousGcRuns = -1L;
    private Long previousGcTime = -1L;

    @Inject
    JvmMetricsSupplier(@NodeId String nodeId) {
        this.initMetrics();
        this.nodeId = nodeId;
    }

    private void initMetrics() {
        this.memoryUsage = Metrics.newGauge(JvmMetricsSupplier.class, (String)"totalUsage", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return VirtualMachineMetrics.getInstance().totalUsed();
            }

            protected double getDenominator() {
                return VirtualMachineMetrics.getInstance().totalMax();
            }
        });
        this.heapUsage = Metrics.newGauge(JvmMetricsSupplier.class, (String)"heapUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                return VirtualMachineMetrics.getInstance().heapUsage();
            }
        });
        this.nonHeapUsage = Metrics.newGauge(JvmMetricsSupplier.class, (String)"nonHeapUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                return VirtualMachineMetrics.getInstance().nonHeapUsage();
            }
        });
        this.threadCount = Metrics.newGauge(JvmMetricsSupplier.class, (String)"threadCount", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return VirtualMachineMetrics.getInstance().threadCount();
            }
        });
        this.gcRuns = Metrics.newGauge(JvmMetricsSupplier.class, (String)"gcRuns", (Gauge)new Gauge<Long>(){

            public Long value() {
                Map map = VirtualMachineMetrics.getInstance().garbageCollectors();
                long runs = 0L;
                for (VirtualMachineMetrics.GarbageCollectorStats each : map.values()) {
                    runs += each.getRuns();
                }
                return runs;
            }
        });
        this.gcTime = Metrics.newGauge(JvmMetricsSupplier.class, (String)"gcTimeMs", (Gauge)new Gauge<Long>(){

            public Long value() {
                Map map = VirtualMachineMetrics.getInstance().garbageCollectors();
                long time = 0L;
                for (VirtualMachineMetrics.GarbageCollectorStats each : map.values()) {
                    time += each.getTime(TimeUnit.MILLISECONDS);
                }
                return time;
            }
        });
        this.averageGcTime = Metrics.newGauge(JvmMetricsSupplier.class, (String)"averageGcTimeMs", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return ((Long)JvmMetricsSupplier.this.gcTime.value()).longValue();
            }

            protected double getDenominator() {
                return ((Long)JvmMetricsSupplier.this.gcRuns.value()).longValue();
            }
        });
        this.fileDescriptorUsage = Metrics.newGauge(JvmMetricsSupplier.class, (String)"fdUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                return VirtualMachineMetrics.getInstance().fileDescriptorUsage();
            }
        });
    }

    @Override
    public String getId() {
        return "jvm";
    }

    @Override
    public String getName() {
        return "Virtual Machine";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        block5: {
            if (PluginSetting.get().isJvmMeasurementsEnabled()) break block5;
            List<MeasurementData> list = Collections.emptyList();
            return list;
        }
        long timestamp = System.currentTimeMillis();
        ArrayList measurements = Lists.newArrayList();
        measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, JvmMetricGroup.MEMORY_USAGE.getMetricName(), (Number)this.memoryUsage.value()));
        if (Bootstrap.isServer()) {
            measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, JvmMetricGroup.HEAP_USAGE.getMetricName(), (Number)this.heapUsage.value()));
            measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, JvmMetricGroup.THREAD_COUNT.getMetricName(), (Number)this.threadCount.value()));
            if (this.previousGcRuns >= 0L) {
                long runs = (Long)this.gcRuns.value() - this.previousGcRuns;
                long time = (Long)this.gcTime.value() - this.previousGcTime;
                measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, JvmMetricGroup.GC_RUNS.getMetricName(), runs));
                measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, JvmMetricGroup.GC_TIME.getMetricName(), time));
            }
            this.previousGcRuns = (Long)this.gcRuns.value();
            this.previousGcTime = (Long)this.gcTime.value();
        }
        ArrayList arrayList = measurements;
        return arrayList;
    }
}

