/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.DiskMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.FileSystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiskMetricsSupplier
implements MeasurementSupplier {
    private static final Logger logger = LoggerFactory.getLogger(DiskMetricsSupplier.class);
    final SystemInfo sysInfo;
    final String nodeId;

    @Inject
    DiskMetricsSupplier(SystemInfo sysInfo, @NodeId String nodeId) {
        this.sysInfo = sysInfo;
        this.nodeId = nodeId;
    }

    @Override
    public String getId() {
        return "fs";
    }

    @Override
    public String getName() {
        return "File System";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        PluginSetting setting;
        block7: {
            setting = PluginSetting.get();
            if (setting.isDiskMeasurementsEnabled()) break block7;
            List<MeasurementData> list = Collections.emptyList();
            return list;
        }
        String str = setting.getMonitoringPaths();
        long timestamp = System.currentTimeMillis();
        ArrayList measurements = Lists.newArrayList();
        if (!this.sysInfo.isNative() || Strings.isNullOrEmpty((String)str)) {
            String path = Quickbuild.getInstance().getStorageDir().getAbsolutePath();
            FileSystemInfo fs = this.sysInfo.getFileSystem(path);
            measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, MetricMeta.of(DiskMetricGroup.USAGE, fs.getMountPoint()).getMetricName(), fs.getUsedPercent()));
        } else {
            HashSet added = Sets.newHashSet();
            for (FileSystemInfo each : this.sysInfo.getFileSystems()) {
                String mountPoint = each.getMountPoint();
                if (added.contains(mountPoint)) {
                    logger.warn("Duplicated mount point: " + mountPoint);
                }
                if (!DiskMetricsSupplier.matches(mountPoint, str) || added.contains(mountPoint)) continue;
                measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, MetricMeta.of(DiskMetricGroup.USAGE, mountPoint).getMetricName(), each.getUsedPercent()));
                added.add(mountPoint);
            }
        }
        ArrayList arrayList = measurements;
        return arrayList;
    }

    private static boolean matches(String path, String pattern) {
        Pair pair = FileUtils.getIncludesExcludes((String)pattern);
        String[] includes = (String[])pair.getFirst();
        String[] excludes = (String[])pair.getSecond();
        boolean match = false;
        for (String each : includes) {
            if (!Objects.equal((Object)"*", (Object)each) && !FileUtils.matches((String)path, (String)each)) continue;
            match = true;
            break;
        }
        if (match) {
            for (String each : excludes) {
                if (!FileUtils.matches((String)path, (String)each)) continue;
                match = false;
                break;
            }
        }
        return match;
    }
}

