/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.measurement.DatabaseMeasurements;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.DatabaseMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

class DatabaseMetricsSupplier
implements MeasurementSupplier {
    final String nodeId;

    @Inject
    DatabaseMetricsSupplier(@NodeId String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public String getId() {
        return "db";
    }

    @Override
    public String getName() {
        return "Database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        if (!Bootstrap.isServer()) {
            return Collections.emptyList();
        }
        if (!PluginSetting.get().isDatabaseMeasurementsEnabled()) {
            return Collections.emptyList();
        }
        long timestamp = System.currentTimeMillis();
        ArrayList measurements = Lists.newArrayList();
        measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, DatabaseMetricGroup.BUSY_CONNECTIONS.getMetricName(), (Number)DatabaseMeasurements.INSTANCE.getNumBusyConnections().value()));
        measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, DatabaseMetricGroup.NUM_CONNECTIONS.getMetricName(), (Number)DatabaseMeasurements.INSTANCE.getTotalConnections().value()));
        ArrayList arrayList = measurements;
        return arrayList;
    }
}

