/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.CpuMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.sysinfo.SystemInfo;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

class CpuMetricsSupplier
implements MeasurementSupplier {
    final Gauge<Double> totalUsage;
    final Gauge<Double> sysUsage;
    final Gauge<Double> waitUsage;
    final Gauge<Double> idleUsage;
    final Gauge<Double> userUsage;
    final Gauge<Double> niceUsage;
    final String nodeId;

    @Inject
    CpuMetricsSupplier(final SystemInfo sysInfo, @NodeId String nodeId) {
        this.nodeId = nodeId;
        this.totalUsage = Metrics.newGauge(CpuMetricsSupplier.class, (String)"totalUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getCpuUsage().getCombined();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
        this.sysUsage = Metrics.newGauge(CpuMetricsSupplier.class, (String)"sysUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getCpuUsage().getSys();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
        this.userUsage = Metrics.newGauge(CpuMetricsSupplier.class, (String)"userUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getCpuUsage().getUser();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
        this.idleUsage = Metrics.newGauge(CpuMetricsSupplier.class, (String)"idleUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getCpuUsage().getIdle();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
        this.waitUsage = Metrics.newGauge(CpuMetricsSupplier.class, (String)"waitUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getCpuUsage().getWait();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
        this.niceUsage = Metrics.newGauge(CpuMetricsSupplier.class, (String)"niceUsage", (Gauge)new Gauge<Double>(){

            public Double value() {
                try {
                    return sysInfo.getCpuUsage().getNice();
                }
                catch (UnsupportedOperationException e) {
                    return Double.NaN;
                }
            }
        });
    }

    @Override
    public String getId() {
        return "cpu";
    }

    @Override
    public String getName() {
        return "CPU";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        if (!PluginSetting.get().isCpuMeasurementsEnabled()) {
            return Collections.emptyList();
        }
        long timestamp = System.currentTimeMillis();
        ArrayList measurements = Lists.newArrayList();
        measurements.add(MeasurementDataBuilder.of(timestamp, this.nodeId, CpuMetricGroup.TOTAL_USAGE.getMetricName(), (Number)this.totalUsage.value()));
        ArrayList arrayList = measurements;
        return arrayList;
    }
}

