/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.supplier;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.measurement.BuildMeasurements;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildRequestMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildsMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.ResourceMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.StepMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.util.MeasurementDataBuilder;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BuildMetricsSupplier
implements MeasurementSupplier {
    static final Logger LOG = LoggerFactory.getLogger(BuildMetricsSupplier.class);
    final String serverId;
    final MetricsManager metricsManager;
    final Lock lock = new ReentrantLock();

    @Inject
    BuildMetricsSupplier(MetricsManager metricsManager, @NodeId String nodeId) {
        this.metricsManager = metricsManager;
        this.serverId = nodeId;
    }

    @Override
    public String getId() {
        return "builds";
    }

    @Override
    public String getName() {
        return "Build Metrics";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementData> get() {
        if (!Bootstrap.isServer()) {
            return Collections.emptyList();
        }
        if (!PluginSetting.get().isBuildMeasurementsEnabled()) {
            return Collections.emptyList();
        }
        this.lock.lock();
        try {
            ArrayList list = Lists.newArrayList();
            long timestamp = System.currentTimeMillis();
            Counter counter = BuildMeasurements.INSTANCE.getBuildsCounter();
            long builds = Math.max(0L, counter.count());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildsMetricGroup.TOTALS.getMetricName(), builds));
            counter.dec(builds);
            counter = BuildMeasurements.INSTANCE.getBuildsFailedCounter();
            long failed = Math.max(0L, counter.count());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildsMetricGroup.FAILED.getMetricName(), failed));
            counter.dec(failed);
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildsMetricGroup.SUCCESSFUL_RATE.getMetricName(), MathUtils.divide((Number)(builds - failed), (Number)builds)));
            Timer buildDuration = BuildMeasurements.INSTANCE.getBuildsTimer();
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildsMetricGroup.AVERAGE_DURATION.getMetricName(), buildDuration.mean()));
            buildDuration.clear();
            Timer waiting = BuildMeasurements.INSTANCE.getBuildsWaitingTimer();
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildsMetricGroup.AVERAGE_WAITING_DURATION.getMetricName(), waiting.mean()));
            waiting.clear();
            Counter requestsCounter = BuildMeasurements.INSTANCE.getProcessedRequestsCounter();
            long requests = Math.max(0L, requestsCounter.count());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildRequestMetricGroup.PROCESSED_TOTAL.getMetricName(), requests));
            requestsCounter.dec(requests);
            Counter submittedCounter = BuildMeasurements.INSTANCE.getSubmittedRequestsCounter();
            long submitted = Math.max(0L, submittedCounter.count());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildRequestMetricGroup.SUBMITTED_REQUESTS.getMetricName(), submitted));
            submittedCounter.dec(submitted);
            this.metricsManager.prepare();
            long count = Math.max(0L, this.metricsManager.getTotalProcessingBuildRequests());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildRequestMetricGroup.PROCESSINGS_TOTAL.getMetricName(), count));
            count = Math.max(this.metricsManager.getTotalWaitingBuildRequests(), 0L);
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, BuildRequestMetricGroup.WAITINGS_TOTAL.getMetricName(), count));
            count = Math.max(0L, this.metricsManager.getTotalRunningSteps());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, StepMetricGroup.RUNNINGS_TOTAL.getMetricName(), count));
            count = Math.max(0L, this.metricsManager.getTotalWaitingSteps());
            list.add(MeasurementDataBuilder.of(timestamp, this.serverId, StepMetricGroup.WAITINGS_TOTAL.getMetricName(), count));
            Map map = this.metricsManager.getFreeResourcesByName();
            for (Map.Entry entry : map.entrySet()) {
                list.add(MeasurementDataBuilder.of(timestamp, this.serverId, MetricMeta.of(ResourceMetricGroup.FREES_BY_NAME, (String)entry.getKey()).getMetricName(), (Number)entry.getValue()));
            }
            map = this.metricsManager.getUsedResourcesByName();
            for (Map.Entry entry : map.entrySet()) {
                list.add(MeasurementDataBuilder.of(timestamp, this.serverId, MetricMeta.of(ResourceMetricGroup.USED_BY_NAME, (String)entry.getKey()).getMetricName(), (Number)entry.getValue()));
            }
            map = this.metricsManager.getProcessingBuildRequestsByNode();
            if (map.isEmpty() && LOG.isDebugEnabled()) {
                LOG.warn("No processing build requests found in current time span");
            }
            for (Map.Entry entry : map.entrySet()) {
                list.add(MeasurementDataBuilder.of(timestamp, (String)entry.getKey(), BuildRequestMetricGroup.PROCESSINGS_ON_NODE.getMetricName(), (Number)entry.getValue()));
            }
            map = this.metricsManager.getRunningStepsByNode();
            if (map.isEmpty() && LOG.isDebugEnabled()) {
                LOG.warn("No running steps found in current time span");
            }
            for (Map.Entry entry : map.entrySet()) {
                list.add(MeasurementDataBuilder.of(timestamp, (String)entry.getKey(), StepMetricGroup.RUNNINGS_ON_NODE.getMetricName(), (Number)entry.getValue()));
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }
}

