/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.setting;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.measurement.core.MeasurementPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.io.Serializable;
import java.util.Stack;
import org.dom4j.Element;

public class PluginSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String monitoringPaths;
    private boolean enabled = true;
    private boolean diskMeasurementsEnabled = true;
    private boolean cpuMeasurementsEnabled = true;
    private boolean buildMeasurementsEnabled = true;
    private boolean webMeasurementsEnabled = true;
    private boolean jvmMeasurementsEnabled = true;
    private boolean databaseMeasurementsEnabled = true;
    private boolean memoryMeasurementsEnabled = true;
    private boolean swapMeasurementsEnabled = true;
    private boolean networkMeasurementsEnabled = true;

    public static PluginSetting get() {
        return PluginSetting.get(true);
    }

    public static PluginSetting get(boolean interpolate) {
        return (PluginSetting)PluginSettingHelper.getSetting(MeasurementPlugin.class, (boolean)interpolate);
    }

    @Editable(name="Collecting Metrics?", order=100, description="Specifies whether collecting the metrics from node or not")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Editable(name="Monitor Disk", order=200, description="Specifies the pathes which you want to monitor the disk usage. Leave empty to just monitor the disk on which the storage directory defined. * to monitor all drives/partitions. You may also specify a Ant style path pattern, for example: C:/,D:/, don't forget the last slash for the drive/partition. Also, when specifying windows drive letter, please use uppercase.Please refer to <a href=\"$docroot/File+Pattern+Reference\">File Pattern Reference</a> for details of valid file patterns.")
    @Scriptable
    public String getMonitoringPaths() {
        return this.monitoringPaths;
    }

    public void setMonitoringPaths(String monitoringPaths) {
        this.monitoringPaths = monitoringPaths;
    }

    @Editable(name="Collecting Disk Usage?", order=300, description="Enable or disable collecting disk usage")
    @Scriptable
    public boolean isDiskMeasurementsEnabled() {
        return this.diskMeasurementsEnabled;
    }

    public void setDiskMeasurementsEnabled(boolean diskMeasurementsEnabled) {
        this.diskMeasurementsEnabled = diskMeasurementsEnabled;
    }

    @Editable(name="Collecting CPU Usage?", order=400, description="Enable or disable collecting CPU usage")
    @Scriptable
    public boolean isCpuMeasurementsEnabled() {
        return this.cpuMeasurementsEnabled;
    }

    public void setCpuMeasurementsEnabled(boolean cpuMeasurementsEnabled) {
        this.cpuMeasurementsEnabled = cpuMeasurementsEnabled;
    }

    @Editable(name="Collecting Build Metrics?", order=500, description="Enable or disable collecting build metrics")
    @Scriptable
    public boolean isBuildMeasurementsEnabled() {
        return this.buildMeasurementsEnabled;
    }

    public void setBuildMeasurementsEnabled(boolean buildMeasurementsEnabled) {
        this.buildMeasurementsEnabled = buildMeasurementsEnabled;
    }

    @Editable(name="Collecting Web Metrics?", order=600, description="Enable or disable collecting web metrics")
    @Scriptable
    public boolean isWebMeasurementsEnabled() {
        return this.webMeasurementsEnabled;
    }

    public void setWebMeasurementsEnabled(boolean webMeasurementsEnabled) {
        this.webMeasurementsEnabled = webMeasurementsEnabled;
    }

    @Editable(name="Collecting JVM Metrics?", order=700, description="Enable or disable collecting JVM metrics")
    @Scriptable
    public boolean isJvmMeasurementsEnabled() {
        return this.jvmMeasurementsEnabled;
    }

    public void setJvmMeasurementsEnabled(boolean jvmMeasurementsEnabled) {
        this.jvmMeasurementsEnabled = jvmMeasurementsEnabled;
    }

    @Editable(name="Collecting Database Connection Usage?", order=800, description="Enable or disable collecting database connection usage")
    @Scriptable
    public boolean isDatabaseMeasurementsEnabled() {
        return this.databaseMeasurementsEnabled;
    }

    public void setDatabaseMeasurementsEnabled(boolean databaseMeasurementsEnabled) {
        this.databaseMeasurementsEnabled = databaseMeasurementsEnabled;
    }

    @Editable(name="Collecting Memory Usage?", order=900, description="Enable or disable collecting physical memory usage")
    @Scriptable
    public boolean isMemoryMeasurementsEnabled() {
        return this.memoryMeasurementsEnabled;
    }

    public void setMemoryMeasurementsEnabled(boolean memoryMeasurementsEnabled) {
        this.memoryMeasurementsEnabled = memoryMeasurementsEnabled;
    }

    @Editable(name="Collecting SWAP Usage?", order=1100, description="Enable or disable collecting swap usage")
    @Scriptable
    public boolean isSwapMeasurementsEnabled() {
        return this.swapMeasurementsEnabled;
    }

    public void setSwapMeasurementsEnabled(boolean swapMeasurementsEnabled) {
        this.swapMeasurementsEnabled = swapMeasurementsEnabled;
    }

    @Editable(name="Collecting Network Metrics?", order=1200, description="Enable or disable collecting network metrics")
    @Scriptable
    public boolean isNetworkMeasurementsEnabled() {
        return this.networkMeasurementsEnabled;
    }

    public void setNetworkMeasurementsEnabled(boolean networkMeasurementsEnabled) {
        this.networkMeasurementsEnabled = networkMeasurementsEnabled;
    }

    public void save() {
        PluginSettingHelper.saveSetting(MeasurementPlugin.class, (Object)this);
    }

    private void updateElementValue(Element root, String fieldName, String value) {
        Element e = root.element(fieldName);
        if (e == null) {
            e = root.addElement(fieldName);
            e.setText(value);
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        this.updateElementValue(root, "diskMeasurementsEnabled", "true");
        this.updateElementValue(root, "cpuMeasurementsEnabled", "true");
        this.updateElementValue(root, "buildMeasurementsEnabled", "true");
        this.updateElementValue(root, "webMeasurementsEnabled", "true");
        this.updateElementValue(root, "jvmMeasurementsEnabled", "true");
        this.updateElementValue(root, "databaseMeasurementsEnabled", "true");
        this.updateElementValue(root, "memoryMeasurementsEnabled", "true");
        this.updateElementValue(root, "swapMeasurementsEnabled", "true");
        this.updateElementValue(root, "networkMeasurementsEnabled", "true");
    }
}

