/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.measurement.MeasurementUtils;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.rest.D3ChartSeries;
import com.pmease.quickbuild.plugin.measurement.core.web.data.TimeSeries;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamsHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestUtils;
import com.pmease.quickbuild.util.TimeUtils;
import com.sun.jersey.api.Responses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.hibernate.criterion.MatchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/grid/measurements")
public class MeasurementsResource {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementsResource.class);

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    @RestHelp(value="Get help for all available functions")
    public String help() {
        String template = ReportHelper.readClassResource(this.getClass(), (String)"help.vm");
        HashMap context = Maps.newHashMap();
        ArrayList categories = Lists.newArrayList(MetricMetaRegistry.instance.getCategories());
        Collections.sort(categories);
        context.put("categories", categories);
        return RestUtils.generateHelp(this.getClass(), (String)template, (Map)context);
    }

    @GET
    @RestHelp(value="Get current version for the measurements related REST API")
    @Path(value="/version")
    public String getApiVersion() {
        return "5.0";
    }

    @GET
    @RestHelp(value="Get grid measurements data.")
    @ParamsHelp(value={@ParamHelp(name="source", description="Specify the node you want to query. If not specifed, then all nodes will be used."), @ParamHelp(name="period", description="Specify the time range you want to query. by default, period is LAST_HOUR, this param can be one of: LAST_HOUR, LAST_2_HOURS, LAST_4_HOURS, LAST_DAY, LAST_WEEK, LAST_MONTH"), @ParamHelp(name="interval", description="Specify the interval of returned measurement data. This param can be one of: RAW, ONE_HOUR, SIX_HOURS and ONE_DAY. <ul class='circle'>\t<li>RAW means the raw data for returned measurement data, that is every 5 minites. Returned data are list of MeasurementDataR01, MeasurementDataR02, MeasurementDataR03, or MeasurementDataR04.</li> \t<li>ONE_HOUR data are aggregated based on RAW data. Returned data are list of MeasurementData1H</li> \t<li>SIX_HOURS data are aggregated based on ONE_HOUR data. Returned data are list of MeasurementData6H.</li> \t<li>ONE_DAY data are aggregated based on SIX_HOURS data. Returned data are list of MeasurementData1D.</li> </ul>If not specified, QuickBuild will calculate the interval automatically according to the time span specified."), @ParamHelp(name="start_time", description="Specify the start time you want to query. If not specified, then an hour ago of end_time will be used."), @ParamHelp(name="end_time", description="Specify the end time you want to query. If not specified, then current time will be used."), @ParamHelp(name="metric", description="Specify the metric id you want to query. For all available metric names, see below table."), @ParamHelp(name="date_pattern", description="Specify the date pattern you are using for from_date and to_date. By default, ISO 8601 is used. Refer to <a href='http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html'>SimpleDateFormat</a> for details.")})
    @Produces(value={"application/xml", "application/json"})
    public List<MeasurementData> get(@QueryParam(value="source") String source, @QueryParam(value="period") String period, @QueryParam(value="interval") String interval, @QueryParam(value="start_time") String from, @QueryParam(value="end_time") String to, @QueryParam(value="metric") String metric, @QueryParam(value="date_pattern") String datePattern) {
        Range range;
        if (!Strings.isNullOrEmpty((String)period)) {
            range = TimeSpan.valueOf((String)period.toUpperCase()).range();
        } else {
            long toDate = Strings.isNullOrEmpty((String)to) ? System.currentTimeMillis() : ((Date)DataTypes.DATE.fromString(to, datePattern)).getTime();
            long fromDate = Strings.isNullOrEmpty((String)from) ? TimeUtils.ago((long)toDate, (long)3600000L) : ((Date)DataTypes.DATE.fromString(from, datePattern)).getTime();
            range = Range.closed((Comparable)Long.valueOf(fromDate), (Comparable)Long.valueOf(toDate));
        }
        MatchMode mode = MatchMode.EXACT;
        if (!Strings.isNullOrEmpty((String)metric)) {
            MetricMeta meta = MetricMetaRegistry.instance.getMeta(metric);
            if (meta == null) {
                throw new WebApplicationException(Responses.notFound().entity((Object)("Metric name " + metric + " is invalid.")).build());
            }
            if (meta.isNeedScope()) {
                mode = MatchMode.START;
            }
        }
        if (Strings.isNullOrEmpty((String)interval)) {
            return MeasurementDataManager.instance.find(range, source, metric, mode);
        }
        MeasurementDataManager.TableType tt = MeasurementDataManager.TableType.valueOf((String)interval.toUpperCase());
        return MeasurementDataManager.instance.find(tt, range, source, metric, mode);
    }

    public List<D3ChartSeries> getSeries(@PathParam(value="metric") String metric, @QueryParam(value="table") String table, @QueryParam(value="period") TimeSpan timespan, @QueryParam(value="start_time") String startTime, @QueryParam(value="end_time") String endTime, @QueryParam(value="datePattern") String datePattern, @QueryParam(value="source") String source) {
        Range range = MeasurementsResource.parseTimeRange(timespan, startTime, endTime, datePattern);
        MeasurementDataManager.TableType tableType = Strings.isNullOrEmpty((String)table) ? MeasurementUtils.getTableType((long)((Long)range.lowerEndpoint()), (long)((Long)range.upperEndpoint())) : MeasurementDataManager.TableType.valueOf((String)table.toUpperCase());
        long interval = tableType.getInterval();
        range = Range.closed((Comparable)Long.valueOf(TimeUtils.roundDownTime((long)((Long)range.lowerEndpoint()), (long)interval)), (Comparable)Long.valueOf(TimeUtils.roundDownTime((long)((Long)range.upperEndpoint()), (long)interval)));
        MetricMeta meta = MetricMetaRegistry.instance.getMeta(metric);
        List measurements = MeasurementDataManager.instance.find(tableType, range, source, metric, meta.isNeedScope() ? MatchMode.START : MatchMode.EXACT);
        Map<TimeSeries.Key, List<MeasurementData>> map = this.groupMeasurements(measurements);
        ArrayList result = Lists.newArrayList();
        for (TimeSeries.Key key : map.keySet()) {
            D3ChartSeries series = new D3ChartSeries(key);
            result.add(series);
            series.setBeginTime((Long)range.lowerEndpoint());
            series.setEndTime((Long)range.upperEndpoint());
            series.setInterval(interval);
            if (meta.isNeedScope()) {
                series.setScope(meta.getScope());
            } else {
                series.setScope("");
            }
            long start = (Long)range.lowerEndpoint();
            int idx = 0;
            List<MeasurementData> d = map.get(key);
            while (start < (Long)range.upperEndpoint()) {
                long end = start + interval;
                MeasurementData found = null;
                while (found == null && idx < d.size()) {
                    MeasurementData data = d.get(idx);
                    if (data.getTimestamp() >= start && data.getTimestamp() < end) {
                        found = data;
                    } else if (data.getTimestamp() >= end) break;
                    ++idx;
                }
                Double value = Double.NaN;
                if (found != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Add DataPoint, original time: " + new Date(found.getTimestamp()) + ", to range [" + new Date(start) + ", " + new Date(end) + "]");
                    }
                    value = found.getValue();
                }
                series.getValues().add(value);
                start = end;
            }
        }
        Collections.sort(result, new Comparator<D3ChartSeries>(){

            @Override
            public int compare(D3ChartSeries s1, D3ChartSeries s2) {
                return s1.getKey().compareTo(s2.getKey());
            }
        });
        return result;
    }

    private Map<TimeSeries.Key, List<MeasurementData>> groupMeasurements(List<MeasurementData> measurements) {
        HashMap map = Maps.newHashMap();
        for (MeasurementData each : measurements) {
            List<MeasurementData> list;
            TimeSeries.Key key = TimeSeries.Key.of(each.getSource(), each.getMetricName());
            if (map.containsKey(key)) {
                list = (List)map.get(key);
            } else {
                list = Lists.newArrayList();
                map.put(key, list);
            }
            list.add(each);
        }
        return map;
    }

    private static final Range<Long> parseTimeRange(TimeSpan timespan, String startTime, String endTime, String datePattern) {
        if (timespan != null) {
            return timespan.range();
        }
        long to = Strings.isNullOrEmpty((String)endTime) ? System.currentTimeMillis() : ((Date)DataTypes.DATE.fromString(endTime, datePattern)).getTime();
        long from = Strings.isNullOrEmpty((String)startTime) ? TimeUtils.ago((long)3600000L) : ((Date)DataTypes.DATE.fromString(startTime, datePattern)).getTime();
        return Range.closed((Comparable)Long.valueOf(from), (Comparable)Long.valueOf(to));
    }
}

