/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.reporter;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.event.NodeAlertEvent;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.plugin.measurement.core.cache.LatestReportCache;
import com.pmease.quickbuild.plugin.measurement.core.cache.UpdatedTimeCache;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementReporter;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.NodeMeasurementReport;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import com.pmease.quickbuild.plugin.measurement.core.reporter.AbstractReporter;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MeasurementServerReporter
extends AbstractReporter
implements MeasurementReporter {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementServerReporter.class);
    private boolean enabled = true;

    public static MeasurementServerReporter enable(boolean enabled) {
        MeasurementServerReporter instance = (MeasurementServerReporter)Quickbuild.getInstance(MeasurementServerReporter.class);
        instance.setEnabled(enabled);
        return instance;
    }

    @Inject
    MeasurementServerReporter(EventBus eventBus) {
        eventBus.register((Object)this);
    }

    @Override
    public String getId() {
        return "serverReporter";
    }

    @Override
    public String getName() {
        return "Server Reporter";
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void run(NodeMeasurementReport report) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending measurement data report [" + report + "] to server ...");
        }
        if (Bootstrap.isServer()) {
            MeasurementServerReporter.save(report);
        } else {
            GridNode serverNode = Grid.instance.getServerNode();
            serverNode.executeJob(NodeMetricsSender.class, new Serializable[]{report});
        }
    }

    private static void save(NodeMeasurementReport report) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving measurement&alert data to database ...");
        }
        if (!GridMock.isEnabled()) {
            MeasurementDataManager.instance.save(report.getMeasurements());
        }
        AlertManager.instance.save(report.getAlerts());
        UpdatedTimeCache.INSTANCE.put(report.getSource(), report.getBeginTime());
        LatestReportCache.INSTANCE.put((Object)report.getSource(), (Object)report);
        if (!report.getAlerts().isEmpty()) {
            AlertManager.instance.publish(new NodeAlertEvent(report.getAlerts(), report.getSource()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished saving measurement&alert data to database ...");
        }
    }

    public static class NodeMetricsSender
    implements NodeJob {
        public Serializable execute(Serializable ... params) {
            Preconditions.checkArgument((params != null && params.length == 1 ? 1 : 0) != 0);
            NodeMeasurementReport data = (NodeMeasurementReport)params[0];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received measurement data: " + data);
            }
            MeasurementServerReporter.save(data);
            return Integer.valueOf(0);
        }
    }
}

