/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.poller;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.inject.Inject;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.MeasurementPlugin;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementSupplier;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.supplier.MeasurementSuppliers;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementPollingTask
extends AbstractExecutionThreadService {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementPollingTask.class);
    private final String nodeId;
    private final EventBus eventBus;

    @Inject
    public MeasurementPollingTask(EventBus eventBus) {
        this.eventBus = eventBus;
        this.nodeId = Grid.instance.getLocalNode().getAddress();
    }

    public void execute() {
        boolean b;
        if (logger.isDebugEnabled()) {
            logger.debug("Begin measurement polling task ...");
        }
        Stopwatch watch = new Stopwatch().start();
        MeasurementPlugin plugin = MeasurementPlugin.getInstance();
        boolean bl = b = Bootstrap.isServer() || Quickbuild.getInstance().isConnected();
        if (plugin.isEnabled() && b && PluginSetting.get().isEnabled()) {
            this.eventBus.post(this.collectMetrics());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ignore collecting metrics due to the plugin is disabled or node is not connected");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Finished measurement polling task in " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
        }
    }

    protected List<MeasurementData> collectMetrics() {
        if (logger.isDebugEnabled()) {
            logger.debug("Begin collecting measurement data on node [" + this.nodeId + "]");
        }
        Set<MeasurementSupplier> suppliers = MeasurementSuppliers.getAllSuppliers();
        ArrayList list = Lists.newArrayList();
        for (MeasurementSupplier supplier : suppliers) {
            Stopwatch watch = new Stopwatch().start();
            List supplied = (List)supplier.get();
            list.addAll(supplied);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Supplier [" + supplier.getId() + "] costs " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Finished collecting measurement data on node [" + this.nodeId + "], " + list.size() + " measurements collected");
        }
        return list;
    }

    protected void run() throws Exception {
        long interval;
        long sleepTime = interval = MeasurementDataManager.instance.getPollingInterval();
        while (this.isRunning()) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                long time = System.currentTimeMillis();
                this.execute();
                long dur = System.currentTimeMillis() - time;
                sleepTime = interval - dur;
                if (sleepTime >= 0L) continue;
                logger.warn("Collecting measurements cost [" + DataTypes.DURATION.asString((Object)dur) + "]. It's too long and there may be some problems");
                sleepTime = 5000L;
            }
            catch (Throwable e) {
                logger.error("Collecting measurement data failed.", e);
            }
        }
    }
}

