/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.poller;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.alert.engine.condition.AlertCondition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertSetting;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertEvent;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertEventBuffer;
import com.pmease.quickbuild.plugin.alert.engine.strategy.AlertFiringStrategy;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.MetricCondition;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.NodeMeasurementReport;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.util.NodeId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MeasurementDataHandler {
    private Map<String, AlertEventBuffer> buffers = Maps.newConcurrentMap();
    private final EventBus eventBus;
    private final String nodeId;

    @Inject
    MeasurementDataHandler(EventBus eventBus, @NodeId String nodeId) {
        this.eventBus = eventBus;
        this.nodeId = nodeId;
    }

    @Subscribe
    public void onReceivedMeasurements(List<MeasurementData> measurements) {
        List<Alert> alerts = this.evaluteAlerts((List<MeasurementData>)ImmutableList.copyOf(measurements));
        NodeMeasurementReport report = new NodeMeasurementReport(this.nodeId, measurements);
        report.setAlerts(alerts);
        this.eventBus.post((Object)report);
    }

    private List<Alert> evaluteAlerts(List<MeasurementData> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        GridNode node = Grid.instance.getLocalNode();
        List<AlertDefinition> definitions = this.getAlertDefinitions();
        if (definitions.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.buffers.isEmpty()) {
            HashSet set = Sets.newHashSet();
            for (String key : this.buffers.keySet()) {
                boolean found = false;
                for (AlertDefinition each : definitions) {
                    if (!each.getName().equalsIgnoreCase(key)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                set.add(key);
            }
            for (Object each : set) {
                this.buffers.remove(each);
            }
        }
        ArrayList alerts = Lists.newArrayList();
        for (Object each : definitions) {
            AlertCondition ad = each.getCondition();
            if (!(ad instanceof MetricCondition)) continue;
            MetricCondition cond = (MetricCondition)ad;
            List violated = (List)cond.apply(list);
            AlertEventBuffer eventBuffer = this.buffers.get(each.getName());
            if (eventBuffer == null) {
                eventBuffer = new AlertEventBuffer();
                this.buffers.put(each.getName(), eventBuffer);
            }
            long cur = eventBuffer.next();
            AlertEvent e = (AlertEvent)eventBuffer.get(cur);
            e.setEventType(violated.isEmpty() ? AlertEvent.EventType.UNMATCH : AlertEvent.EventType.MATCH);
            eventBuffer.publish(cur);
            AlertFiringStrategy strategy = each.getFiringStrategy();
            if (!strategy.satisfies(eventBuffer)) continue;
            ArrayList values = Lists.newArrayList();
            for (MeasurementData v : violated) {
                MetricMeta meta = MetricMeta.fromFullName(v.getMetricName());
                values.add(meta.getFullName() + "=" + meta.getDataType().asString((Object)v.getValue()));
            }
            Alert alert = new Alert();
            alert.setPriority(each.getPriority());
            alert.setSubject(each.getName());
            alert.setTrigger(node.getAddress());
            alert.setAlertMessage(Joiner.on((String)", ").join((Iterable)values));
            alert.setCategory(Alert.AlertCategory.METRIC);
            alerts.add(alert);
            eventBuffer.resetLastN(strategy.getCheckCount());
        }
        return alerts;
    }

    private List<AlertDefinition> getAlertDefinitions() {
        AlertSetting setting = AlertSetting.get();
        if (setting == null) {
            return Collections.emptyList();
        }
        List conditions = setting.getDefinitions();
        ArrayList result = Lists.newArrayList();
        for (AlertDefinition each : conditions) {
            if (!each.isEnabled() || !each.getNodeMatcher().matches(Grid.instance.getLocalNode())) continue;
            result.add(each);
        }
        return result;
    }
}

