/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.poller;

import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.pmease.quickbuild.plugin.measurement.core.manager.MeasurementCompressionManager;
import com.pmease.quickbuild.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementCompressionTask
extends AbstractExecutionThreadService {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementCompressionTask.class);

    protected void run() throws Exception {
        long current = System.currentTimeMillis();
        long nextHour = TimeUtils.roundDownTime((long)current, (long)3600000L) + 3600000L;
        long sleepTime = nextHour - current;
        if (sleepTime > 3600000L) {
            sleepTime = 3600000L;
        }
        while (this.isRunning()) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                break;
            }
            current = System.currentTimeMillis();
            try {
                MeasurementCompressionManager.instance.compressAndPurge();
            }
            catch (Throwable e) {
                logger.error("Compress measurement data encountered error.", e);
            }
            if ((sleepTime = 3600000L - (System.currentTimeMillis() - current)) >= 0L) continue;
            sleepTime = 60000L;
        }
    }
}

