/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.mock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.ResourceManager;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.plugin.measurement.core.mock.GridMock;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ResourceMock {
    private static Map<String, Resource> resources = Maps.newTreeMap();

    static void init() {
        String name = "My Resource";
        for (int i = 0; i < 100; ++i) {
            MyResource res = new MyResource();
            res.setName(name + " " + i);
            resources.put(res.getName(), res);
        }
    }

    public static List<Resource> getResources() {
        List list = GridMock.isEnabled() ? Lists.newArrayList(resources.values()) : CacheManager.instance.getResources();
        Collections.sort(list, new Comparator<Resource>(){

            @Override
            public int compare(Resource r1, Resource r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        return list;
    }

    public static Resource getResource(String name) {
        if (GridMock.isEnabled()) {
            return resources.get(name);
        }
        return ResourceManager.instance.get(name);
    }

    static class MyResource
    extends Resource {
        private static final long serialVersionUID = 1L;

        MyResource() {
        }

        public int getCount() {
            return 100;
        }
    }
}

