/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.mock;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.measurement.core.mock.ResourceMock;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.util.OsType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class GridMock {
    private static boolean enabled = false;
    private static Map<String, GridNode> nodes = Maps.newLinkedHashMap();
    private static GridNode serverNode;
    private static Map<String, NodeTraits> traitsCache;
    private static final String[] HOSTS;

    public static void enable() {
        enabled = true;
        serverNode = Grid.instance.getServerNode();
        GridMock.addNode(serverNode);
        NodeTraits traits = new NodeTraits();
        traits.update();
        traitsCache.put(serverNode.getAddress(), traits);
        Random rand = new Random();
        int port = 5080;
        for (int i = 1; i < 50; ++i) {
            GridNode copied = new GridNode(UUID.randomUUID(), serverNode.getIp(), port + i, i % 3 == 0);
            copied.setHostName(HOSTS[i % HOSTS.length]);
            copied.setBenchmark((long)Math.abs(rand.nextInt(9999)));
            copied.setIsServer(false);
            GridMock.addNode(copied);
            NodeTraits nodeTraits = new NodeTraits();
            nodeTraits.update();
            int k = Math.abs(rand.nextInt());
            if (k > OsType.values().length) {
                k %= OsType.values().length;
            }
            nodeTraits.setOsType(OsType.values()[k]);
            traitsCache.put(copied.getAddress(), nodeTraits);
        }
        ResourceMock.init();
    }

    public static void addNode(GridNode node) {
        nodes.put(node.getAddress(), node);
    }

    public static Optional<GridNode> getNode(String nodeAddress) {
        if (enabled) {
            return Optional.of((Object)nodes.get(nodeAddress));
        }
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node == null) {
            return Optional.absent();
        }
        return Optional.of((Object)node);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<GridNode> getNodes() {
        ArrayList result;
        if (enabled) {
            result = Lists.newArrayList(nodes.values());
        } else {
            result = Lists.newArrayList();
            result.add(Grid.instance.getServerNode());
            result.addAll(AgentManager.instance.getBuildAgents());
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public static NodeTraits getTraits(GridNode node) {
        if (enabled) {
            return traitsCache.get(node.getAddress());
        }
        return (NodeTraits)node.getCharacteristics().getExtraCharacteristics().get(NodeTraits.KEY);
    }

    static {
        traitsCache = Maps.newHashMap();
        HOSTS = new String[]{"agent1.pmease.com", "agent2.pmease.com", "agent3.pmease.com", "agent4.pmease.com", "agent5.pmease.com", "agent6.pmease.com", "agent7.pmease.com", "agent8.pmease.com", "agent9.pmease.com", "agent10.pmease.com"};
    }
}

