/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.meta;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.io.Serializable;

public class MetricMeta
implements Serializable,
Comparable<MetricMeta> {
    private static final long serialVersionUID = 1L;
    private final MetricCategory category;
    private final String name;
    private final DataType dataType;
    private final boolean needScope;
    private String scope;
    private String displayName;
    private int ordinal;
    private String description;
    private MetricType metricType = MetricType.SERVER;

    public static MetricMeta of(MetricCategory category, String name, DataType dataType) {
        return MetricMeta.of(category, name, dataType, null);
    }

    public static MetricMeta of(MetricCategory category, String name, DataType dataType, String displayName) {
        return MetricMeta.of(category, name, dataType, false, displayName);
    }

    public static MetricMeta of(MetricCategory category, String name, DataType dataType, boolean needScope, String displayName) {
        return new MetricMeta(category, name, dataType, needScope, displayName);
    }

    public static MetricMeta of(MetricMeta other) {
        return MetricMeta.of(other.category, other.name, other.dataType, other.needScope, other.displayName).setMetricType(other.metricType).setScope(other.scope).setDescription(other.description).setOrdinal(other.ordinal);
    }

    public static MetricMeta of(MetricMeta other, String scope) {
        return MetricMeta.of(other).setScope(scope);
    }

    public static MetricMeta fromFullName(String fullName) {
        return MetricMetaRegistry.instance.getMeta(fullName);
    }

    MetricMeta(MetricCategory category, String name, DataType dataType) {
        this(category, name, dataType, null);
    }

    MetricMeta(MetricCategory category, String name, DataType dataType, String displayName) {
        this(category, name, dataType, false, displayName);
    }

    MetricMeta(MetricCategory category, String name, DataType dataType, boolean needScope, String displayName) {
        this.category = category;
        this.name = name;
        this.dataType = dataType;
        this.needScope = needScope;
        this.displayName = displayName;
    }

    public String getScope() {
        return this.scope;
    }

    public MetricMeta setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScopeValue(String fullName) {
        String metricName = this.getMetricName();
        if (fullName.startsWith(metricName) && fullName.length() > metricName.length() + 1) {
            return fullName.substring(metricName.length() + 1);
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetricMeta setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MetricCategory getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isNeedScope() {
        return this.needScope;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public MetricMeta setOrdinal(int ordinal) {
        this.ordinal = ordinal;
        return this;
    }

    public String getMetricName() {
        return this.category.getId() + "." + this.name + (this.scope == null ? "" : "." + this.scope);
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public MetricMeta setMetricType(MetricType sourceType) {
        this.metricType = sourceType;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MetricMeta setDescription(String description) {
        this.description = description;
        return this;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMetricName()});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetricMeta)) {
            return false;
        }
        MetricMeta rhs = (MetricMeta)other;
        return Objects.equal((Object)this.getMetricName(), (Object)rhs.getMetricName());
    }

    public String getFullName() {
        String str = this.category.getName() + " :: " + this.getDisplayName();
        if (!Strings.isNullOrEmpty((String)this.scope)) {
            str = str + " :: " + this.scope;
        }
        return str;
    }

    public String toString() {
        return this.getMetricName();
    }

    @Override
    public int compareTo(MetricMeta o) {
        int r = this.category.ordinal() - o.category.ordinal();
        if (r != 0) {
            return r;
        }
        r = this.ordinal - o.ordinal;
        if (r != 0) {
            return r;
        }
        return this.ordinal - o.ordinal;
    }
}

