/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.meta;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import java.util.List;

public class JvmMetricGroup
extends MetricCategory {
    private static final long serialVersionUID = 1L;
    public static final String ID = "jvm";
    public static final JvmMetricGroup instance = new JvmMetricGroup();
    public static final MetricMeta MEMORY_USAGE = MetricMeta.of(instance, "memoryUsage", DataTypes.PERCENT, "Memory Usage").setMetricType(MetricType.NODE).setOrdinal(10);
    public static final MetricMeta HEAP_USAGE = MetricMeta.of(instance, "heapUsage", DataTypes.PERCENT, "Heap Usage").setMetricType(MetricType.SERVER).setOrdinal(20);
    public static final MetricMeta GC_RUNS = MetricMeta.of(instance, "gcRuns", DataTypes.LONG, "GC Runs").setMetricType(MetricType.SERVER).setOrdinal(30);
    public static final MetricMeta GC_TIME = MetricMeta.of(instance, "gcTime", DataTypes.DURATION, "GC Time").setMetricType(MetricType.SERVER).setOrdinal(40);
    public static final MetricMeta THREAD_COUNT = MetricMeta.of(instance, "threadCount", DataTypes.INTEGER, "Thread Count").setMetricType(MetricType.SERVER).setOrdinal(40);

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Virtual Machine";
    }

    @Override
    public List<MetricMeta> getMetas() {
        return ImmutableList.of((Object)MEMORY_USAGE, (Object)HEAP_USAGE, (Object)GC_RUNS, (Object)GC_TIME, (Object)THREAD_COUNT);
    }

    @Override
    public int ordinal() {
        return 10;
    }
}

