/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.meta;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricGroupEnum;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Singleton
public class DefaultMetricMetaRegistry
implements MetricMetaRegistry {
    private Map<String, MetricCategory> groups = Maps.newConcurrentMap();
    private Map<String, MetricMeta> metas = Maps.newConcurrentMap();

    @Override
    public void addCategory(MetricCategory group) {
        this.groups.put(group.getId(), group);
        for (MetricMeta each : group.getMetas()) {
            this.metas.put(each.getMetricName(), each);
        }
    }

    @Override
    @Nullable
    public MetricMeta getMeta(final String metricName) {
        return this.getMeta(metricName, new Predicate<MetricMeta>(){

            public boolean apply(@Nullable MetricMeta input) {
                return metricName.startsWith(input.getMetricName());
            }
        });
    }

    @Override
    @Nullable
    public MetricMeta getMeta(String metricName, Predicate<MetricMeta> predicate) {
        if (Strings.isNullOrEmpty((String)metricName)) {
            return null;
        }
        MetricMeta m = this.metas.get(metricName);
        if (m == null) {
            m = (MetricMeta)Iterables.find(this.getMetas(), predicate, null);
        }
        if (m == null) {
            return m;
        }
        String scope = m.getScopeValue(metricName);
        if (Strings.isNullOrEmpty((String)scope)) {
            return m;
        }
        return MetricMeta.of(m, scope);
    }

    @Override
    public Set<MetricMeta> getMetas() {
        return ImmutableSet.copyOf(this.metas.values());
    }

    @Override
    public Set<MetricCategory> getCategories() {
        return ImmutableSet.copyOf(this.groups.values());
    }

    @Override
    @Nullable
    public MetricCategory getCategory(String groupId) {
        return this.groups.get(groupId);
    }

    @Override
    public Set<MetricCategory> getCategoriesOfType(final MetricType type) {
        Iterable it = Iterables.filter(this.groups.values(), (Predicate)new Predicate<MetricCategory>(){

            public boolean apply(@Nullable MetricCategory group) {
                return DefaultMetricMetaRegistry.this.isApplicable(group, type);
            }
        });
        return ImmutableSet.copyOf((Iterable)it);
    }

    private boolean isApplicable(MetricCategory group, MetricType scope) {
        for (MetricMeta each : group.getMetas()) {
            if (!scope.includes(each.getMetricType())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public MetricCategory getCategoryOfMetric(String metricName) {
        MetricMeta meta = this.getMeta(metricName);
        if (meta == null) {
            return null;
        }
        return meta.getCategory();
    }

    @Override
    public void init() {
        LinkedHashSet enums = Sets.newLinkedHashSet(EnumSet.allOf(MetricGroupEnum.class));
        for (MetricGroupEnum e : enums) {
            this.addCategory(e.getMetricGroup());
        }
    }
}

