/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.meta;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.measurement.core.meta.ServletType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import java.util.List;

public abstract class AbstractServletMetaSet
extends MetricCategory {
    private static final long serialVersionUID = 1L;
    final ServletType servletType;

    protected AbstractServletMetaSet(ServletType type) {
        this.servletType = type;
    }

    @Override
    public String getId() {
        return "web." + this.servletType.name().toLowerCase();
    }

    public MetricMeta oneMinuteRate() {
        return MetricMeta.of(this, "oneMinuteRate", DataTypes.DOUBLE, "One-minute Rate").setMetricType(MetricType.SERVER).setOrdinal(10);
    }

    public MetricMeta fiveMinuteRate() {
        return MetricMeta.of(this, "fiveMinuteRate", DataTypes.DOUBLE, "Five-minute Rate").setMetricType(MetricType.SERVER).setOrdinal(20);
    }

    public MetricMeta fifteenMinuteRate() {
        return MetricMeta.of(this, "fifteenMinuteRate", DataTypes.DOUBLE, "Fifteen-minute Rate").setMetricType(MetricType.SERVER).setOrdinal(30);
    }

    public MetricMeta requests() {
        return MetricMeta.of(this, "requests", DataTypes.LONG, "Requests").setMetricType(MetricType.SERVER).setOrdinal(40);
    }

    public MetricMeta averageDuration() {
        return MetricMeta.of(this, "averageDuration", DataTypes.DURATION, "Average Duration").setMetricType(MetricType.SERVER).setOrdinal(50);
    }

    @Override
    public List<MetricMeta> getMetas() {
        return ImmutableList.of((Object)this.oneMinuteRate(), (Object)this.fiveMinuteRate(), (Object)this.fifteenMinuteRate(), (Object)this.requests(), (Object)this.averageDuration());
    }
}

