/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.manager.impl;

import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.measurement.MeasurementUtils;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.MeasurementData1D;
import com.pmease.quickbuild.model.MeasurementData1H;
import com.pmease.quickbuild.model.MeasurementData6H;
import com.pmease.quickbuild.model.MeasurementDataAggregate;
import com.pmease.quickbuild.persistence.SessionInterceptor;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.plugin.measurement.core.manager.MeasurementCompressionManager;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildRequestMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildsMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.StepMetricGroup;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.TimeUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class DefaultMeasurementCompressionManager
implements MeasurementCompressionManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMeasurementCompressionManager.class);
    @Inject
    MeasurementDataManager dataManager;
    private static final String BUILD_TOTALS = BuildsMetricGroup.TOTALS.getMetricName();
    private static final String BUILD_FAILED = BuildsMetricGroup.FAILED.getMetricName();
    private static final String SUCCESS_RATE = BuildsMetricGroup.SUCCESSFUL_RATE.getMetricName();
    private static List<String> FILTERED_METRICS = ImmutableList.of((Object)BuildsMetricGroup.TOTALS.getMetricName(), (Object)BuildsMetricGroup.FAILED.getMetricName(), (Object)StepMetricGroup.RUNNINGS_TOTAL.getMetricName(), (Object)StepMetricGroup.WAITINGS_TOTAL.getMetricName(), (Object)StepMetricGroup.RUNNINGS_ON_NODE.getMetricName(), (Object)BuildRequestMetricGroup.PROCESSINGS_TOTAL.getMetricName(), (Object)BuildRequestMetricGroup.PROCESSED_TOTAL.getMetricName(), (Object)BuildRequestMetricGroup.WAITINGS_TOTAL.getMetricName(), (Object)BuildRequestMetricGroup.PROCESSINGS_ON_NODE.getMetricName(), (Object)BuildsMetricGroup.SUCCESSFUL_RATE.getMetricName());

    DefaultMeasurementCompressionManager() {
    }

    protected Session getSession() {
        Session session = SessionInterceptor.getSession();
        if (session == null) {
            throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
        }
        return session;
    }

    @Override
    public void compressAndPurge() {
        this.compressAndPurge(System.currentTimeMillis());
    }

    @Override
    public void compressAndPurge(long currentMills) {
        Class[] rawTables;
        logger.debug("Compressing measurement data ...");
        Stopwatch watch = new Stopwatch().start();
        long now = TimeUtils.roundDownTime((long)currentMills, (long)3600000L);
        long hourAgo = TimeUtils.roundDownTime((long)(now - 3600000L), (long)3600000L);
        Class deadTable = MeasurementUtils.getDeadTable((long)hourAgo);
        int deadTableIndex = MeasurementUtils.getTableNameIndex((Class)deadTable);
        for (Class rawTable : rawTables = MeasurementUtils.getAllRawTables((int)(deadTableIndex + 1))) {
            if (rawTable.equals(deadTable)) continue;
            this.compressData(rawTable, MeasurementData1H.class, 3600000L, now);
        }
        this.truncateDeadTable(now, deadTable);
        long last = this.compressData(MeasurementData1H.class, MeasurementData6H.class, 21600000L, now);
        this.purgeMeasurements(MeasurementData1H.class, Math.min(now - 1209600000L, last), 3600000L);
        last = this.compressData(MeasurementData6H.class, MeasurementData1D.class, 86400000L, now);
        this.purgeMeasurements(MeasurementData6H.class, Math.min(now - 2592000000L, last), 21600000L);
        this.purgeMeasurements(MeasurementData1D.class, now - 31536000000L, 86400000L);
        logger.info("Compressing and purging measurement data in " + watch.elapsed(TimeUnit.SECONDS) + " seconds");
    }

    private long compressData(Class<? extends MeasurementData> fromTable, Class<? extends MeasurementData> toTable, long interval, long now) {
        long fromTableMax;
        long start = this.dataManager.getMaxTimestamp(toTable);
        if (start == 0L) {
            start = this.dataManager.getMinTimestamp(fromTable);
            if (start == 0L) {
                return 0L;
            }
        } else {
            start += interval;
        }
        long rawTimeStart = TimeUtils.roundDownTime((long)MeasurementUtils.getRawTimePeriodStart((long)now), (long)3600000L);
        long begin = TimeUtils.roundDownTime((long)start, (long)interval);
        if (begin < rawTimeStart) {
            begin = rawTimeStart;
        }
        if ((fromTableMax = this.dataManager.getMaxTimestamp(fromTable)) < begin) {
            if (logger.isDebugEnabled()) {
                logger.debug("fromTableMax: [" + new Date(fromTableMax) + "] less than begin [" + new Date(begin) + "], ignoring");
            }
            return begin;
        }
        return this.compressData(fromTable, toTable, begin, now, interval);
    }

    private long compressData(Class<? extends MeasurementData> fromTable, Class<? extends MeasurementData> toTable, long begin, long now, long interval) {
        logger.info("Begin compression from [" + fromTable.getSimpleName() + "] to [" + toTable.getSimpleName() + "]");
        int totalRows = 0;
        while (begin < now) {
            long end = begin + interval;
            try {
                totalRows += this.compressDataInterval(fromTable, toTable, begin, end);
            }
            catch (Throwable t) {
                logger.error("Unable to compress data from [" + fromTable.getSimpleName() + "] to [" + toTable.getSimpleName() + "] at " + new Date(begin), t);
            }
            begin = end;
        }
        logger.info("Finished compression from [" + fromTable.getSimpleName() + "] to [" + toTable.getSimpleName() + "], [" + totalRows + "] compressed rows");
        return begin;
    }

    public int compressDataInterval(Class<? extends MeasurementData> fromTable, Class<? extends MeasurementData> toTable, long begin, long end) {
        int j = this.compressDataInterval(fromTable, toTable, false, begin, end);
        int i = this.compressDataInterval(fromTable, toTable, true, begin, end);
        return i + j;
    }

    private List<String> getFilteredMetrics() {
        return FILTERED_METRICS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressDataInterval(Class<? extends MeasurementData> fromTable, Class<? extends MeasurementData> toTable, boolean buildMetrics, long begin, long end) {
        logger.info("Begin compressing data from table [" + fromTable.getSimpleName() + "] to table [" + toTable.getSimpleName() + "] between [" + new Date(begin) + "] and [" + new Date(end) + "]");
        Stopwatch watch = new Stopwatch().start();
        String minMax = buildMetrics ? "SUM(ft.value), " : "AVG(ft.value), ";
        minMax = MeasurementUtils.isRawTable(fromTable) ? minMax + "MIN(ft.value), MAX(ft.value)" : minMax + "MIN(ft.minValue), MAX(ft.maxValue)";
        String hql = "  SELECT ft.source, ft.metricName, " + minMax + "  \tFROM " + fromTable.getSimpleName() + " ft " + " \tWHERE ft.timestamp >= :begin AND ft.timestamp <= :end ";
        hql = buildMetrics ? hql + " AND (ft.metricName IN (:metrics)) " : hql + " AND (ft.metricName NOT IN (:metrics)) ";
        hql = hql + " \tGROUP BY ft.source, ft.metricName";
        Session session = SessionManager.openSession();
        int rows = 0;
        try {
            Query q = session.createQuery(hql);
            q.setLong("begin", begin);
            q.setLong("end", end);
            q.setParameterList("metrics", this.getFilteredMetrics());
            List list = q.list();
            rows = list.size();
            Transaction tx = session.beginTransaction();
            int i = 0;
            MeasurementData totalsData = null;
            MeasurementData failedData = null;
            MeasurementData successfulRateData = null;
            for (Object[] bean : list) {
                MeasurementData data = (MeasurementData)ClassUtils.instantiateClass(toTable, (Object[])new Object[0]);
                data.setTimestamp(begin);
                data.setSource((String)bean[0]);
                data.setMetricName((String)bean[1]);
                data.setValue((Double)bean[2]);
                MeasurementDataAggregate agg = (MeasurementDataAggregate)data;
                agg.setMinValue((Double)bean[3]);
                agg.setMaxValue((Double)bean[4]);
                if (buildMetrics) {
                    if (data.getMetricName().equalsIgnoreCase(BUILD_TOTALS)) {
                        totalsData = data;
                    } else if (data.getMetricName().equalsIgnoreCase(BUILD_FAILED)) {
                        failedData = data;
                    } else if (data.getMetricName().equalsIgnoreCase(SUCCESS_RATE)) {
                        successfulRateData = data;
                    }
                }
                if (buildMetrics && data.getMetricName().equalsIgnoreCase(SUCCESS_RATE)) continue;
                session.saveOrUpdate((Object)data);
                if (i++ % 100 != 0) continue;
                session.flush();
                session.clear();
            }
            if (totalsData != null && failedData != null && successfulRateData != null) {
                successfulRateData.setValue(Double.valueOf(MathUtils.divide((Number)(totalsData.getValue() - failedData.getValue()), (Number)totalsData.getValue())));
            }
            if (successfulRateData != null) {
                session.saveOrUpdate(successfulRateData);
            }
            session.flush();
            session.clear();
            tx.commit();
        }
        finally {
            SessionManager.closeSession();
        }
        logger.info("Finished compressing data from table [" + fromTable.getSimpleName() + "] to table [" + toTable.getSimpleName() + "] between [" + new Date(begin) + "] and [" + new Date(end) + "], [" + rows + "] compressed rows in [" + watch.elapsed(TimeUnit.MILLISECONDS) + "] millis");
        return rows;
    }

    private void purgeMeasurements(Class<? extends MeasurementData> table, long purgeBefore, long interval) {
        logger.info("Begin purging data from table [" + table.getSimpleName() + "] before [" + new Date(purgeBefore) + "]");
        int totalRows = 0;
        int rows = 1;
        long min = this.dataManager.getMinTimestamp(table);
        long start = purgeBefore - interval;
        if (min == 0L) {
            logger.info("No data to purge from table [" + table.getSimpleName() + "]");
        } else {
            while (start + interval >= min) {
                try {
                    rows = this.purgeMeasurementInterval(table, start, start + interval);
                    totalRows += rows;
                }
                catch (Throwable t) {
                    logger.error("Unable to purge data from table [" + table + "] between [" + new Date(start) + "] and [" + new Date(start + interval) + "]", t);
                }
                start -= interval;
            }
        }
        logger.info("Finished purging data from table [" + table.getSimpleName() + "] before [" + new Date(purgeBefore) + "], [" + totalRows + "] rows removed");
    }

    @SessionAware(transactional=true)
    public int purgeMeasurementInterval(Class<? extends MeasurementData> table, long purgeBefore, long purgeAfter) {
        logger.info("Begin purging data from table [" + table.getSimpleName() + "] between [" + new Date(purgeBefore) + "] and [" + new Date(purgeAfter) + "]");
        Stopwatch watch = new Stopwatch().start();
        int rows = -1;
        String sql = "DELETE FROM " + table.getSimpleName() + " WHERE timestamp >= :before AND timestamp <= :after";
        Query query = this.getSession().createQuery(sql);
        query.setParameter("before", (Object)purgeBefore);
        query.setParameter("after", (Object)purgeAfter);
        rows = query.executeUpdate();
        logger.info("Finished purging data from table [" + table.getSimpleName() + "] between [" + new Date(purgeBefore) + "] and [" + new Date(purgeAfter) + "], [" + rows + "] rows removed in [" + watch.elapsed(TimeUnit.MILLISECONDS) + "] millis");
        return rows;
    }

    private void truncateDeadTable(long now, Class<? extends MeasurementData> table) {
        if (Objects.equal(table, (Object)MeasurementUtils.getDeadTable((long)now))) {
            logger.info("Begin truncating dead table [" + table.getSimpleName() + "]");
            Stopwatch watch = new Stopwatch().start();
            int rows = 0;
            try {
                rows = this.executeSql("TRUNCATE TABLE QB_MEASUREMENT_DATAR0" + MeasurementUtils.getTableIndex(table));
            }
            catch (Exception e) {
                rows = this.executeHql("DELETE FROM " + table.getSimpleName());
            }
            logger.info("Finished truncating dead table [" + table.getSimpleName() + "], [" + rows + "] rows removed in [" + watch.elapsed(TimeUnit.MILLISECONDS) + "] millis");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeSql(String sql) {
        Session session = SessionManager.openSession();
        try {
            Transaction tx = session.beginTransaction();
            SQLQuery query = session.createSQLQuery(sql);
            int rows = query.executeUpdate();
            tx.commit();
            int n = rows;
            return n;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeHql(String hql) {
        Session session = SessionManager.openSession();
        try {
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery(hql);
            int rows = query.executeUpdate();
            tx.commit();
            int n = rows;
            return n;
        }
        finally {
            SessionManager.closeSession();
        }
    }
}

