/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.extensionpoint;

import com.google.common.base.Objects;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.MeasurementReport;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildRequestMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.CpuMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.JvmMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.StepMetricGroup;
import java.util.List;

public class NodeMeasurementReport
extends MeasurementReport
implements Comparable<NodeMeasurementReport> {
    private static final long serialVersionUID = 1L;
    private final String source;
    private List<Alert> alerts;

    public NodeMeasurementReport(String source, List<MeasurementData> measurements) {
        super(measurements);
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Double getCpuUsage() {
        return this.getLastValue(CpuMetricGroup.TOTAL_USAGE.getMetricName());
    }

    public Double getJvmMemoryUsage() {
        return this.getLastValue(JvmMetricGroup.MEMORY_USAGE.getMetricName());
    }

    public Long getBuildRequestProcessings() {
        Double d = this.getLastValue(BuildRequestMetricGroup.PROCESSINGS_ON_NODE.getMetricName());
        if (d.isNaN()) {
            return 0L;
        }
        return d.longValue();
    }

    public Long getStepRunnings() {
        return this.getLastValue(StepMetricGroup.RUNNINGS_ON_NODE.getMetricName()).longValue();
    }

    public List<Alert> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(List<Alert> alerts) {
        this.alerts = alerts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeMeasurementReport)) {
            return false;
        }
        NodeMeasurementReport rhs = (NodeMeasurementReport)other;
        return Objects.equal((Object)this.source, (Object)rhs.source) && Objects.equal((Object)this.getBeginTime(), (Object)rhs.getBeginTime()) && Objects.equal((Object)this.getEndTime(), (Object)rhs.getEndTime());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.getBeginTime(), this.getEndTime()});
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Node: [").append(this.source).append("], ");
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public int compareTo(NodeMeasurementReport o) {
        int r = this.source.compareTo(o.source);
        if (r != 0) {
            return r;
        }
        r = new Long(this.getBeginTime()).compareTo(o.getBeginTime());
        if (r != 0) {
            return r;
        }
        return new Long(this.getEndTime()).compareTo(o.getEndTime());
    }
}

