/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.extensionpoint;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.MeasurementData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.criterion.MatchMode;

public class MeasurementReport
implements Serializable,
Iterable<MeasurementData> {
    private static final long serialVersionUID = 1L;
    final List<MeasurementData> measurements;

    public MeasurementReport(List<MeasurementData> measurements) {
        this.measurements = measurements;
    }

    public Double getLastValue(String metricName) {
        MeasurementData data = this.getLast(metricName);
        return data == null ? 0.0 : data.getValue();
    }

    public MeasurementData getLast(String metricName) {
        if (Strings.isNullOrEmpty((String)metricName)) {
            return (MeasurementData)Iterables.getLast(this.measurements);
        }
        return (MeasurementData)Iterables.getLast(this.findMeasurements(metricName), null);
    }

    public List<MeasurementData> findMeasurements(String metricName) {
        return this.findMeasurements(metricName, MatchMode.EXACT);
    }

    public List<MeasurementData> findMeasurements(String metricName, MatchMode mode) {
        ArrayList list = Lists.newArrayList();
        for (MeasurementData each : this.measurements) {
            boolean found = false;
            if (mode == MatchMode.ANYWHERE) {
                found = each.getMetricName().contains(metricName);
            } else if (mode == MatchMode.EXACT) {
                found = each.getMetricName().equals(metricName);
            } else if (mode == MatchMode.START) {
                found = each.getMetricName().startsWith(metricName);
            } else if (mode == MatchMode.END) {
                found = each.getMetricName().endsWith(metricName);
            }
            if (!found) continue;
            list.add(each);
        }
        return list;
    }

    public long getBeginTime() {
        MeasurementData data = (MeasurementData)Iterables.getFirst(this.measurements, null);
        return data == null ? 0L : data.getTimestamp();
    }

    public long getEndTime() {
        MeasurementData data = (MeasurementData)Iterables.getLast(this.measurements, null);
        return data == null ? 0L : data.getTimestamp();
    }

    public List<MeasurementData> getMeasurements() {
        return this.measurements;
    }

    @Override
    public Iterator<MeasurementData> iterator() {
        return this.measurements.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("beginTime: [").append(new Date(this.getBeginTime())).append("], ");
        sb.append("endTime: [").append(new Date(this.getEndTime())).append("]");
        if (this.measurements.isEmpty()) {
            sb.append("\nNo measurements");
        }
        for (MeasurementData each : this.measurements) {
            sb.append("\n").append(each);
        }
        return sb.toString();
    }
}

