/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.contribution;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.resource.ResourceMetricsPanel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

@Editable(name="Resources Heatmap", category={"Grid Measurements & Alerts"})
public class ResourceHeatmapGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private String timespan = TimeSpan.LAST_HOUR.name();
    private boolean showDetails = false;

    public Component renderBody(String componentId) {
        MetricsChartSetting chartSetting = new MetricsChartSetting();
        chartSetting.setChartTypes(MetricsChartSetting.ChartType.TABLE);
        chartSetting.setTimespan(TimeSpan.valueOf((String)this.getTimespan()));
        chartSetting.setShowDetails(this.isShowDetails());
        return new ResourceMetricsPanel(componentId, (IModel)Model.of((Serializable)chartSetting)){

            @Override
            protected Component createControls(String id) {
                return new WebMarkupContainer(id).setVisibilityAllowed(false);
            }

            @Override
            protected boolean isShowSectionLabel() {
                return false;
            }
        };
    }

    @Editable(name="Time Period", order=100)
    @NotNull
    @ChoiceProvider(value="getAvailableTimeSpan")
    public String getTimespan() {
        return this.timespan;
    }

    public void setTimespan(String timespan) {
        this.timespan = timespan;
    }

    @Editable(name="Show more details", description="The option will be applied to time longer than one day. For LAST_DAY, 5 minutes data will be displayed, for LAST_WEEK, 1 hour data will be displayed, and for LAST_MONTH, 6 hours data will be displayed.")
    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    private static List<String> getAvailableTimeSpan() {
        return ImmutableList.of((Object)TimeSpan.LAST_HOUR.name(), (Object)TimeSpan.LAST_2_HOURS.name(), (Object)TimeSpan.LAST_4_HOURS.name(), (Object)TimeSpan.LAST_DAY.name(), (Object)TimeSpan.LAST_WEEK.name(), (Object)TimeSpan.LAST_MONTH.name());
    }
}

