/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.contribution;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.contribution.NodeNotExistPanel;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricType;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.node.MeasurementPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Node Measurements", category={"Grid Measurements & Alerts"})
public class NodeMetricsGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private String nodeAddress;
    private String metricGroup;
    private String timespan = TimeSpan.LAST_HOUR.name();
    private String chartType = MetricsChartSetting.ChartType.LINE.name();
    private boolean showDetails = false;

    @Editable(name="Node", order=100)
    @NotEmpty
    @ChoiceProvider(value="getAvailableNodes")
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    @Editable(name="Metric Group", order=150)
    @NotEmpty
    @ChoiceProvider(value="getMetricGroups")
    public String getMetricGroup() {
        return this.metricGroup;
    }

    public void setMetricGroup(String metricGroup) {
        this.metricGroup = metricGroup;
    }

    @Editable(name="Time Period", order=200)
    @NotEmpty
    @ChoiceProvider(value="getAvailableTimeSpan")
    public String getTimespan() {
        return this.timespan;
    }

    public void setTimespan(String timespan) {
        this.timespan = timespan;
    }

    @Editable(name="Chart Type", order=300)
    @NotEmpty
    @ChoiceProvider(value="getAvailableChartTypes")
    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    @Editable(name="Show more details", description="The option will be applied to time longer than one day. For LAST_DAY, 5 minutes data will be displayed, for LAST_WEEK, 1 hour data will be displayed, and for LAST_MONTH, 6 hours data will be displayed.")
    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public Component renderBody(String componentId) {
        String nodeAddress = this.getNodeAddress();
        if (Strings.isNullOrEmpty((String)nodeAddress)) {
            return new NodeNotExistPanel(componentId, "N/A");
        }
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node == null) {
            return new NodeNotExistPanel(componentId, "N/A");
        }
        MetricsChartSetting setting = new MetricsChartSetting();
        String primaryGroup = this.getMetricCategoryId();
        setting.setTimespan(TimeSpan.valueOf((String)this.getTimespan()));
        setting.setChartTypes(MetricsChartSetting.ChartType.valueOf(this.getChartType()));
        setting.setPrimaryGroup(primaryGroup);
        setting.setShowMetricGroupControls(primaryGroup == null);
        setting.setShowChartButtons(false);
        setting.setShowDetails(this.isShowDetails());
        return new MeasurementPanel(componentId, this.getNodeAddress(), (IModel)Model.of((Serializable)setting)){

            @Override
            protected boolean isShowChartControls() {
                return false;
            }
        };
    }

    private String getMetricCategoryId() {
        String name = this.getMetricGroup();
        if (Objects.equal((Object)name, (Object)"All")) {
            return null;
        }
        Set<MetricCategory> categories = MetricMetaRegistry.instance.getCategories();
        for (MetricCategory each : categories) {
            if (!Objects.equal((Object)each.getName(), (Object)name)) continue;
            return each.getId();
        }
        throw new IllegalArgumentException("Unknown metric category " + name);
    }

    private static List<String> getMetricGroups() {
        HashSet categories = Sets.newHashSet();
        block0: for (MetricCategory each : MetricMetaRegistry.instance.getCategories()) {
            for (MetricMeta meta : each.getMetas()) {
                if (meta.getMetricType() != MetricType.NODE && meta.getMetricType() != MetricType.SERVER) continue;
                categories.add(each);
                continue block0;
            }
        }
        ArrayList sorted = Lists.newArrayList((Iterable)categories);
        Collections.sort(sorted);
        ArrayList names = Lists.newArrayList();
        names.add("All");
        for (MetricCategory each : sorted) {
            names.add(each.getName());
        }
        return names;
    }

    private static List<String> getAvailableNodes() {
        ArrayList nodes = Lists.newArrayList((Iterable)Grid.instance.getAllNodes());
        Collections.sort(nodes);
        ArrayList list = Lists.newArrayList();
        for (GridNode each : nodes) {
            list.add(each.getAddress());
        }
        return list;
    }

    private static List<String> getAvailableChartTypes() {
        return ImmutableList.of((Object)MetricsChartSetting.ChartType.TABLE.name(), (Object)MetricsChartSetting.ChartType.LINE.name(), (Object)MetricsChartSetting.ChartType.AREA.name());
    }

    private static List<String> getAvailableTimeSpan() {
        return ImmutableList.of((Object)TimeSpan.LAST_HOUR.name(), (Object)TimeSpan.LAST_2_HOURS.name(), (Object)TimeSpan.LAST_4_HOURS.name(), (Object)TimeSpan.LAST_DAY.name(), (Object)TimeSpan.LAST_WEEK.name(), (Object)TimeSpan.LAST_MONTH.name());
    }
}

