/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.contribution;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.meta.CpuMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.JvmMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.web.node.GridHeatmapPanel;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;

@Editable(name="Active Nodes Heatmap", category={"Grid Measurements & Alerts"})
public class GridHeatmapGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private String timespan = TimeSpan.LAST_HOUR.name();
    private String metric;
    private boolean showDetails;
    private static final String JVM_MEMORY_USAGE = "Virtual Machine :: Memory Usage";
    private static final String CPU_TOTAL_USAGE = "CPU :: Total Usage";

    @Editable(name="Time Period", order=100)
    @NotNull
    @ChoiceProvider(value="getAvailableTimeSpan")
    public String getTimespan() {
        return this.timespan;
    }

    public void setTimespan(String timespan) {
        this.timespan = timespan;
    }

    @Editable(name="Metric Group", order=200)
    @NotNull
    @Choices(value={"Virtual Machine :: Memory Usage", "CPU :: Total Usage"})
    public String getMetric() {
        return this.metric;
    }

    @Editable(name="Show more details", description="The option will be applied to time longer than one day. For LAST_DAY, 5 minutes data will be displayed, for LAST_WEEK, 1 hour data will be displayed, and for LAST_MONTH, 6 hours data will be displayed.")
    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Component renderBody(String componentId) {
        MetricMeta meta = Objects.equal((Object)this.getMetric(), (Object)JVM_MEMORY_USAGE) ? JvmMetricGroup.MEMORY_USAGE : CpuMetricGroup.TOTAL_USAGE;
        TimeSpan span = TimeSpan.valueOf((String)this.getTimespan());
        return new GridHeatmapPanel(componentId, span, meta, this.isShowDetails()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void createHeadControls(WebMarkupContainer headspan) {
                headspan.setVisibilityAllowed(false);
            }
        };
    }

    private static List<String> getAvailableTimeSpan() {
        return ImmutableList.of((Object)TimeSpan.LAST_HOUR.name(), (Object)TimeSpan.LAST_2_HOURS.name(), (Object)TimeSpan.LAST_4_HOURS.name(), (Object)TimeSpan.LAST_DAY.name(), (Object)TimeSpan.LAST_WEEK.name(), (Object)TimeSpan.LAST_MONTH.name());
    }
}

