/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.contribution;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.alert.engine.util.TimeSpan;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildRequestMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.BuildsMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.meta.StepMetricGroup;
import com.pmease.quickbuild.plugin.measurement.core.web.MetricsChartSetting;
import com.pmease.quickbuild.plugin.measurement.core.web.node.BuildMetricsPanel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

@Editable(name="Build Measurements", category={"Grid Measurements & Alerts"})
public class BuildMetricsGadget
extends Gadget {
    private String chartType = MetricsChartSetting.ChartType.LINE.name();
    private String timespan = TimeSpan.LAST_HOUR.name();
    private String metricGroup = "All";
    private boolean showDetails = false;

    @Editable(name="Chart Type", order=100)
    @NotNull
    @ChoiceProvider(value="getAvailableChartTypes")
    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    @Editable(name="Time Period", order=200)
    @NotNull
    @ChoiceProvider(value="getAvailableTimeSpan")
    public String getTimespan() {
        return this.timespan;
    }

    public void setTimespan(String timespan) {
        this.timespan = timespan;
    }

    @Editable(name="Metric Category", order=300)
    @NotNull
    @ChoiceProvider(value="getMetricGroups")
    public String getMetricGroup() {
        return this.metricGroup;
    }

    public void setMetricGroup(String metricGroup) {
        this.metricGroup = metricGroup;
    }

    @Editable(name="Show more details", description="The option will be applied to time longer than one day. For LAST_DAY, 5 minutes data will be displayed, for LAST_WEEK, 1 hour data will be displayed, and for LAST_MONTH, 6 hours data will be displayed.")
    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public Component renderBody(String componentId) {
        MetricsChartSetting setting = new MetricsChartSetting();
        String primaryId = this.getMetricCategoryId();
        setting.setChartTypes(MetricsChartSetting.ChartType.valueOf(this.getChartType()));
        setting.setTimespan(TimeSpan.valueOf((String)this.getTimespan()));
        setting.setShowChartButtons(false);
        setting.setPrimaryGroup(primaryId);
        setting.setShowMetricGroupControls(primaryId == null);
        setting.setShowDetails(this.isShowDetails());
        return new BuildMetricsPanel(componentId, (IModel)Model.of((Serializable)setting)){

            @Override
            protected boolean isShowChartControls() {
                return false;
            }
        };
    }

    private String getMetricCategoryId() {
        String name = this.getMetricGroup();
        if (Objects.equal((Object)"All", (Object)name)) {
            return null;
        }
        if (Objects.equal((Object)name, (Object)BuildsMetricGroup.instance.getName())) {
            return BuildsMetricGroup.instance.getId();
        }
        if (Objects.equal((Object)name, (Object)StepMetricGroup.instance.getName())) {
            return StepMetricGroup.instance.getId();
        }
        if (Objects.equal((Object)name, (Object)BuildRequestMetricGroup.instance.getName())) {
            return BuildRequestMetricGroup.instance.getId();
        }
        throw new IllegalArgumentException("Unknown metric category " + name);
    }

    private static List<String> getAvailableTimeSpan() {
        return ImmutableList.of((Object)TimeSpan.LAST_HOUR.name(), (Object)TimeSpan.LAST_2_HOURS.name(), (Object)TimeSpan.LAST_4_HOURS.name(), (Object)TimeSpan.LAST_DAY.name(), (Object)TimeSpan.LAST_WEEK.name(), (Object)TimeSpan.LAST_MONTH.name());
    }

    private static List<String> getAvailableChartTypes() {
        return ImmutableList.of((Object)MetricsChartSetting.ChartType.TABLE.name(), (Object)MetricsChartSetting.ChartType.LINE.name(), (Object)MetricsChartSetting.ChartType.AREA.name());
    }

    private static List<String> getMetricGroups() {
        return ImmutableList.of((Object)"All", (Object)BuildsMetricGroup.instance.getName(), (Object)StepMetricGroup.instance.getName(), (Object)BuildRequestMetricGroup.instance.getName());
    }
}

