/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.codec;

import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.protobuf.Message;
import com.pmease.quickbuild.measurement.MeasurementUtils;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.plugin.measurement.core.codec.GMeasurementProtos;
import com.pmease.quickbuild.plugin.measurement.core.codec.ProtoBufCodec;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.wicket.util.io.IOUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

public class MetricTest {
    public void run() throws IOException {
        this.backup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws IOException {
        File file = new File("/Users/zhenyu/MeasurementDataR01-4.bak");
        FileInputStream in = (FileInputStream)Files.newInputStreamSupplier((File)file).getInput();
        ProtoBufCodec codec = new ProtoBufCodec((Supplier<? extends Message.Builder>)Suppliers.ofInstance((Object)GMeasurementProtos.GMeasurementList.newBuilder()));
        try {
            Stopwatch watch = new Stopwatch().start();
            GMeasurementProtos.GMeasurementList list = (GMeasurementProtos.GMeasurementList)codec.deserialize(in);
            System.out.println("Total count " + list.getDataCount());
            System.out.println(list.getData(9999));
            System.out.println("Load data in " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    void backup() {
        Set set = MeasurementUtils.RAW_TABLE_MAP.values();
        for (Class each : set) {
            this.save(each, ProtoBufWriter.instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(Class<? extends MeasurementData> table, Function<Context, Void> writer) {
        Session session = SessionManager.openSession();
        try {
            String hql = "SELECT id from " + table.getSimpleName() + " ORDER BY id desc";
            Query query = session.createQuery(hql);
            query.setMaxResults(1);
            Long maxId = (Long)query.uniqueResult();
            if (maxId == null) {
                return;
            }
            long startId = 0L;
            long interval = 100000L;
            int i = 1;
            while (startId < maxId) {
                Stopwatch watch = new Stopwatch().start();
                Criteria crit = session.createCriteria(table);
                long endId = startId + interval;
                crit.add(Restrictions.between((String)"id", (Object)startId, (Object)endId));
                List list = crit.list();
                File file = new File("/Users/zhenyu/" + table.getSimpleName() + "-" + String.valueOf(i++) + ".bak");
                Context context = new Context();
                context.measurements = list;
                context.outputFile = file;
                writer.apply((Object)context);
                System.out.println("Saving " + list.size() + " rows in " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
                startId = endId;
            }
        }
        finally {
            SessionManager.closeSession();
        }
    }

    static class ProtoBufWriter
    implements Function<Context, Void> {
        static ProtoBufWriter instance = new ProtoBufWriter();

        ProtoBufWriter() {
        }

        public Void apply(@Nullable Context context) {
            GMeasurementProtos.GMeasurementList.Builder builder = GMeasurementProtos.GMeasurementList.newBuilder();
            FileOutputStream os = null;
            try {
                os = (FileOutputStream)Files.newOutputStreamSupplier((File)context.outputFile).getOutput();
                for (MeasurementData measurementData : context.measurements) {
                    GMeasurementProtos.GMeasurementData data = GMeasurementProtos.GMeasurementData.newBuilder().setSource(measurementData.getSource()).setMetricName(measurementData.getMetricName()).setTimestamp(measurementData.getTimestamp()).setValue(measurementData.getValue()).build();
                    builder.addData(data);
                }
                builder.build().writeTo(os);
                os.flush();
            }
            catch (IOException e) {
                try {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)os);
            return null;
        }
    }

    static class Context {
        List<? extends MeasurementData> measurements;
        File outputFile;

        Context() {
        }
    }
}

