/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public enum UpdatedTimeCache {
    INSTANCE;

    private AtomicLong latest = new AtomicLong(0L);
    private LoadingCache<String, Long> cache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String nodeAddress) throws Exception {
            Long time = MeasurementDataManager.instance.getLastTimestamp(nodeAddress);
            if (time == null) {
                time = 0L;
            }
            if (UpdatedTimeCache.this.latest.get() < time) {
                UpdatedTimeCache.this.latest.set(time);
            }
            return time;
        }
    });

    public long get(String source) {
        return (Long)this.cache.getUnchecked((Object)source);
    }

    public long getLatest() {
        return this.latest.get();
    }

    public void put(String source, long timestamp) {
        this.cache.put((Object)source, (Object)timestamp);
        this.latest.set(timestamp);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void invalidate(String source) {
        this.cache.invalidate((Object)source);
    }

    public Map<String, Long> asMap() {
        return this.cache.asMap();
    }
}

