/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.plugin.measurement.core.cache.UpdatedTimeCache;
import com.pmease.quickbuild.plugin.measurement.core.extensionpoint.NodeMeasurementReport;
import com.pmease.quickbuild.util.TimeUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LatestReportCache {
    public static LoadingCache<String, NodeMeasurementReport> INSTANCE = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterAccess(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, NodeMeasurementReport>(){

        public NodeMeasurementReport load(String nodeAddress) throws Exception {
            long lastUpdated = UpdatedTimeCache.INSTANCE.get(nodeAddress);
            long ago = TimeUtils.ago((long)lastUpdated, (long)300000L);
            MeasurementDataManager dataManager = MeasurementDataManager.instance;
            List measurements = dataManager.find(Range.closed((Comparable)Long.valueOf(ago), (Comparable)Long.valueOf(lastUpdated)), nodeAddress);
            NodeMeasurementReport report = new NodeMeasurementReport(nodeAddress, measurements);
            return report;
        }
    });

    private LatestReportCache() {
    }
}

