/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.alert.condition;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.MetricCondition;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.Operator;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Metric condition")
public class SingleMetricCondition
implements MetricCondition {
    private static final long serialVersionUID = 1L;
    private String metricName;
    private Operator operator = Operator.greater_than;
    private double threshold;

    public List<MeasurementData> apply(Iterable<MeasurementData> input) {
        ArrayList result = Lists.newArrayList();
        MetricMeta meta = MetricMetaRegistry.instance.getMeta(this.metricName);
        for (MeasurementData each : input) {
            if (!this.canProcess(each)) continue;
            double value = each.getValue();
            boolean applied = false;
            switch (this.operator) {
                case less_than: {
                    applied = value < this.threshold;
                    break;
                }
                case less_equal: {
                    applied = value <= this.threshold;
                    break;
                }
                case equal: {
                    applied = value == this.threshold;
                    break;
                }
                case greater_than: {
                    applied = value > this.threshold;
                    break;
                }
                default: {
                    boolean bl = applied = value >= this.threshold;
                }
            }
            if (applied) {
                result.add(each);
            }
            if (meta.isNeedScope()) continue;
            break;
        }
        return result;
    }

    public boolean canProcess(MeasurementData data) {
        return data.getMetricName().startsWith(this.metricName);
    }

    @Override
    public Set<String> getMetricNames() {
        return ImmutableSet.of((Object)this.metricName);
    }

    @Editable(name="Metric Name", order=100)
    @ChoiceProvider(value="getAllMetrics")
    @NotEmpty
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    @Editable(name="Operator", order=200)
    @NotNull
    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Editable(name="Threshold", order=300)
    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    static List<String> getAllMetrics() {
        ArrayList metas = Lists.newArrayList(MetricMetaRegistry.instance.getMetas());
        ArrayList names = Lists.newArrayList();
        Collections.sort(metas);
        for (MetricMeta each : metas) {
            names.add(each.getMetricName());
        }
        return names;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.metricName, this.operator, this.threshold});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleMetricCondition)) {
            return false;
        }
        SingleMetricCondition rhs = (SingleMetricCondition)other;
        return Objects.equal((Object)this.metricName, (Object)rhs.metricName) && Objects.equal((Object)((Object)this.operator), (Object)((Object)rhs.operator)) && Objects.equal((Object)this.threshold, (Object)rhs.threshold);
    }

    public String toString() {
        MetricMeta meta = MetricMetaRegistry.instance.getMeta(this.metricName);
        if (meta == null) {
            return "Metric name " + this.metricName + " is invalid";
        }
        return meta.getFullName() + " " + this.operator.getOp() + " " + meta.getDataType().asString((Object)this.threshold);
    }
}

