/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.alert.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.plugin.alert.engine.condition.AlertCondition;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.MetricCondition;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.SingleMetricCondition;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.wicket.util.lang.Objects;
import org.hibernate.validator.constraints.NotEmpty;

public class CompositeCondition
implements MetricCondition {
    private static final long serialVersionUID = 1L;
    private Type type = Type.ALL;
    private List<SingleMetricCondition> conditions = Lists.newArrayList();

    public List<MeasurementData> apply(Iterable<MeasurementData> measurements) {
        HashMap statuses = Maps.newHashMap();
        for (MeasurementData each : measurements) {
            for (SingleMetricCondition cond : this.getConditions()) {
                boolean b;
                if (!cond.canProcess(each)) continue;
                List<MeasurementData> r = cond.apply((Iterable<MeasurementData>)ImmutableList.of((Object)each));
                boolean bl = b = !r.isEmpty();
                if (statuses.containsKey(each.getMetricName())) {
                    b = this.type == Type.ALL ? ((Boolean)statuses.get(each.getMetricName())).booleanValue() && b : (Boolean)statuses.get(each.getMetricName()) != false || b;
                }
                statuses.put(each.getMetricName(), b);
            }
        }
        HashSet violatedNames = Sets.newHashSet();
        HashSet notViolated = Sets.newHashSet(this.getMetricNames());
        for (String each : statuses.keySet()) {
            boolean b = (Boolean)statuses.get(each);
            MetricMeta meta = MetricMetaRegistry.instance.getMeta(each);
            if (b) {
                violatedNames.add(each);
                notViolated.remove(MetricMeta.of(meta, null).getMetricName());
                continue;
            }
            if (this.type != Type.ALL || meta.isNeedScope()) continue;
            return Collections.emptyList();
        }
        if (violatedNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.type == Type.ALL && !notViolated.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (MeasurementData each : measurements) {
            if (!violatedNames.contains(each.getMetricName())) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    public Set<String> getMetricNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SingleMetricCondition each : this.conditions) {
            builder.addAll(each.getMetricNames());
        }
        return builder.build();
    }

    @Editable(name="Type", order=100)
    @NotNull
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Editable(name="Criteria", order=200)
    @NotEmpty
    @Size(min=1)
    public List<SingleMetricCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<SingleMetricCondition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(SingleMetricCondition a) {
        this.conditions.add(a);
    }

    public void removeCondition(SingleMetricCondition a) {
        this.conditions.remove(a);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.conditions});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositeCondition)) {
            return false;
        }
        CompositeCondition rhs = (CompositeCondition)other;
        return Objects.equal(this.conditions, rhs.conditions);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String conn = this.type == Type.ALL ? " and " : " or ";
        for (int i = 0; i < this.conditions.size(); ++i) {
            AlertCondition each = this.conditions.get(i);
            if (this.conditions.size() > 1) {
                sb.append("(");
            }
            sb.append(each.toString());
            if (this.conditions.size() > 1) {
                sb.append(")");
            }
            if (i + 1 >= this.conditions.size()) continue;
            sb.append(conn);
        }
        return sb.toString();
    }

    public String toHtml() {
        boolean b;
        StringBuffer sb = new StringBuffer();
        String conn = this.type == Type.ALL ? " and " : " or ";
        boolean bl = b = this.conditions.size() > 1;
        if (b) {
            sb.append("<ul class='square'>");
        }
        for (int i = 0; i < this.conditions.size(); ++i) {
            AlertCondition each = this.conditions.get(i);
            if (b) {
                sb.append("<li>");
            }
            sb.append(each.toString());
            if (i + 1 < this.conditions.size()) {
                sb.append("<span> ").append(conn).append(" </span>");
            }
            if (!b) continue;
            sb.append("</li>");
        }
        if (b) {
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public static enum Type {
        ALL,
        ANY;

    }
}

