/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core.alert;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.alert.engine.condition.AlertCondition;
import com.pmease.quickbuild.plugin.alert.engine.setting.AlertDefinition;
import com.pmease.quickbuild.plugin.alert.engine.setting.ConditionEditor;
import com.pmease.quickbuild.plugin.measurement.core.alert.ListEditor;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.CompositeCondition;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.Operator;
import com.pmease.quickbuild.plugin.measurement.core.alert.condition.SingleMetricCondition;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricCategory;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMeta;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataSizeType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DurationType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.WildcardListModel;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class CompositeConditionEditor
extends ConditionEditor {
    private CompositeCondition condition;
    private List<SingleMetricCondition> conditions = Lists.newArrayList();
    private Form<?> form;

    public CompositeConditionEditor(String id, IModel<AlertDefinition> model, Form<?> form) {
        super(id, model, form);
        this.form = form;
        this.setOutputMarkupId(true);
    }

    private AlertDefinition getDefinition() {
        return (AlertDefinition)this.getDefaultModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.condition = (CompositeCondition)this.getDefinition().getCondition();
        if (this.condition == null) {
            this.condition = new CompositeCondition();
            this.conditions.add(new SingleMetricCondition());
        } else {
            this.conditions = this.condition.getConditions();
        }
        this.add(new Component[]{new AjaxButton("addlink", this.form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                CompositeConditionEditor.this.conditions.add(new SingleMetricCondition());
                CompositeConditionEditor.this.onConditionsChanged(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }
        }});
        DropDownChoice typeDropDown = new DropDownChoice("type", (IModel)new PropertyModel((Object)this.condition, "type"), (List)Lists.newArrayList((Object[])CompositeCondition.Type.values()));
        typeDropDown.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                CompositeConditionEditor.this.onConditionsChanged(target);
            }
        }});
        this.add(new Component[]{typeDropDown});
        this.add(new Component[]{this.createEditor("conditions")});
    }

    private void onConditionsChanged(AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{this.createEditor("conditions")});
        target.add(new Component[]{this});
    }

    private boolean isSameGroup(String name1, String name2) {
        if (name1 == null) {
            return false;
        }
        MetricCategory g1 = MetricMetaRegistry.instance.getCategoryOfMetric(name1);
        MetricCategory g2 = MetricMetaRegistry.instance.getCategoryOfMetric(name2);
        return Objects.equal((Object)g1, (Object)g2);
    }

    private Component createEditor(String id) {
        ListEditor<SingleMetricCondition> editor = new ListEditor<SingleMetricCondition>(id, (IModel)new WildcardListModel(this.conditions)){

            public void updateModel() {
                this.setDefaultModelObject(CompositeConditionEditor.this.conditions);
            }
        };
        int i = 0;
        while (i < this.conditions.size()) {
            String markupId = editor.newChildId();
            final SingleMetricCondition cond = this.conditions.get(i);
            final WebMarkupContainer container = new WebMarkupContainer(markupId, (IModel)Model.of((Serializable)((Object)cond)));
            container.setOutputMarkupId(true);
            container.add(new Component[]{new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)container))});
            editor.add(new Component[]{container});
            DropDownChoice<String> metricChoice = new DropDownChoice<String>("metric", (IModel)new PropertyModel((Object)cond, "metricName"), this.getMetricNames(), (IChoiceRenderer)new IChoiceRenderer<String>(){

                public Object getDisplayValue(String object) {
                    return MetricMetaRegistry.instance.getMeta(object).getFullName();
                }

                public String getIdValue(String object, int index) {
                    return object;
                }
            }){
                private String last;

                private boolean isLast(int index) {
                    return index - 1 == this.getChoices().size();
                }

                private boolean isFirst(int index) {
                    return index == 0;
                }

                private boolean isNewGroup(String current) {
                    return this.last == null || !CompositeConditionEditor.this.isSameGroup(this.last, current);
                }

                private String getGroupLabel(String current) {
                    return MetricMetaRegistry.instance.getMeta(current).getCategory().getName();
                }

                protected void appendOptionHtml(AppendingStringBuffer buffer, String choice, int index, String selected) {
                    if (this.isNewGroup(choice)) {
                        if (!this.isFirst(index)) {
                            buffer.append("</optgroup>");
                        }
                        buffer.append("<optgroup label='");
                        buffer.append((Object)Strings.escapeMarkup((CharSequence)this.getGroupLabel(choice)));
                        buffer.append("'>");
                    }
                    super.appendOptionHtml(buffer, (Object)choice, index, selected);
                    if (this.isLast(index)) {
                        buffer.append("</optgroup>");
                    }
                    this.last = choice;
                }
            };
            metricChoice.setRequired(true);
            metricChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    target.add(new Component[]{container});
                }
            }});
            container.add(new Component[]{metricChoice});
            container.add(new Component[]{new DropDownChoice("op", (IModel)new PropertyModel((Object)cond, "operator"), (List)Lists.newArrayList((Object[])Operator.values()), (IChoiceRenderer)new IChoiceRenderer<Operator>(){

                public Object getDisplayValue(Operator object) {
                    return object.getOp();
                }

                public String getIdValue(Operator object, int index) {
                    return object.name();
                }
            }).setRequired(true)});
            container.add(new Component[]{new TextField("threshold", (IModel)new PropertyModel((Object)cond, "threshold")).setRequired(true)});
            container.add(new Component[]{new Label("logic", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return CompositeConditionEditor.this.condition.getType() == CompositeCondition.Type.ALL ? "AND" : "OR";
                }
            })});
            container.add(new Component[]{new Label("desc", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    String metricName = cond.getMetricName();
                    if (metricName == null) {
                        return "";
                    }
                    MetricMeta meta = MetricMetaRegistry.instance.getMeta(metricName);
                    DataType dataType = meta.getDataType();
                    if (dataType instanceof PercentType) {
                        return " (from 0.0 to 1.0)";
                    }
                    if (dataType instanceof DurationType) {
                        return "milliseconds";
                    }
                    if (dataType instanceof DataSizeType) {
                        return "bytes";
                    }
                    return "";
                }
            })});
            final int index = i++;
            container.add(new Component[]{new AjaxButton("remove", this.form){

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    CompositeConditionEditor.this.conditions.remove(index);
                    if (CompositeConditionEditor.this.conditions.isEmpty()) {
                        CompositeConditionEditor.this.conditions.add(new SingleMetricCondition());
                    }
                    CompositeConditionEditor.this.onConditionsChanged(target);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            }.setDefaultFormProcessing(false)});
        }
        return editor;
    }

    private List<String> getMetricNames() {
        ArrayList list = Lists.newArrayList();
        ArrayList metas = Lists.newArrayList(MetricMetaRegistry.instance.getMetas());
        Collections.sort(metas);
        for (MetricMeta each : metas) {
            list.add(each.getMetricName());
        }
        return list;
    }

    public boolean onSubmit(AjaxRequestTarget target, Form<?> form) {
        if (this.conditions.isEmpty()) {
            form.error((Serializable)((Object)"At least one condition should be add"));
            target.add(new Component[]{form});
            return false;
        }
        this.condition.setConditions(this.conditions);
        this.getDefinition().setCondition((AlertCondition)this.condition);
        return true;
    }
}

