/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.measurement.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.NodeCharacteristicsPopulator;
import com.pmease.quickbuild.extensionpoint.RestResourceContribution;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.measurement.core.alert.CompositeConditionCreator;
import com.pmease.quickbuild.plugin.measurement.core.contribution.BuildMetricsGadget;
import com.pmease.quickbuild.plugin.measurement.core.contribution.GridHeatmapGadget;
import com.pmease.quickbuild.plugin.measurement.core.contribution.MeasurementTab;
import com.pmease.quickbuild.plugin.measurement.core.contribution.NodeMetricsGadget;
import com.pmease.quickbuild.plugin.measurement.core.contribution.ResourceHeatmapGadget;
import com.pmease.quickbuild.plugin.measurement.core.meta.MetricMetaRegistry;
import com.pmease.quickbuild.plugin.measurement.core.poller.MeasurementCompressionTask;
import com.pmease.quickbuild.plugin.measurement.core.poller.MeasurementDataHandler;
import com.pmease.quickbuild.plugin.measurement.core.poller.MeasurementPollingTask;
import com.pmease.quickbuild.plugin.measurement.core.reporter.MeasurementServerReporter;
import com.pmease.quickbuild.plugin.measurement.core.rest.MeasurementsResource;
import com.pmease.quickbuild.plugin.measurement.core.setting.PluginSetting;
import com.pmease.quickbuild.plugin.measurement.core.trait.NodeTraits;
import com.pmease.quickbuild.plugin.measurement.core.web.node.UserFilters;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.FileUtils;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.JmxReporter;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.osgi.framework.BundleContext;

public class MeasurementPlugin
extends AbstractPlugin {
    private final MetricMetaRegistry metricMetaRegistry;
    private final MeasurementPollingTask pollingTask;
    private final MeasurementCompressionTask compressionTask;
    private final NodeTraits nodeTraits;

    @Inject
    MeasurementPlugin(MetricMetaRegistry metaReg, MeasurementPollingTask pollingTask, MeasurementCompressionTask compressionTask, NodeTraits nodeTraits, EventBus eventBus, MeasurementDataHandler dataHandler) {
        this.metricMetaRegistry = metaReg;
        this.pollingTask = pollingTask;
        this.compressionTask = compressionTask;
        this.nodeTraits = nodeTraits;
        eventBus.register((Object)dataHandler);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        System.setProperty("org.hyperic.sigar.path", FileUtils.locateLib(MeasurementPlugin.class, (String)"libsigar").getAbsolutePath());
        this.metricMetaRegistry.init();
        JmxReporter.startDefault((MetricsRegistry)Metrics.defaultRegistry());
        MeasurementServerReporter.enable(true);
        if (Bootstrap.isServer() || Bootstrap.isBuildAgent()) {
            this.pollingTask.start();
        }
        if (Bootstrap.isServer()) {
            this.compressionTask.start();
        }
        this.nodeTraits.update();
    }

    public void stop(BundleContext context) throws Exception {
        JmxReporter.shutdownDefault();
        this.pollingTask.stop();
        if (Bootstrap.isServer()) {
            this.compressionTask.stop();
        }
        super.stop(context);
    }

    public void settingChanged() {
        super.settingChanged();
    }

    public Object[] getExtensions() {
        return new Object[]{new MeasurementTab(), new CompositeConditionCreator(), new NodeCharacteristicsPopulator(){

            public void populate(Map<String, Serializable> nodeData) {
                nodeData.put(NodeTraits.KEY, MeasurementPlugin.this.nodeTraits);
            }
        }, new RestResourceContribution(){

            public Set<Class<?>> getResourceClasses() {
                return ImmutableSet.of(MeasurementsResource.class);
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return GridHeatmapGadget.class;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return ResourceHeatmapGadget.class;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return BuildMetricsGadget.class;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return NodeMetricsGadget.class;
            }
        }};
    }

    public Class<?> getSettingClass() {
        return PluginSetting.class;
    }

    public Class<?> getUserSettingClass() {
        return UserFilters.class;
    }

    public PluginCategory getCategory() {
        return PluginCategory.MEASUREMENT;
    }

    public static MeasurementPlugin getInstance() {
        return (MeasurementPlugin)PluginManager.instance.getPlugin(MeasurementPlugin.class);
    }
}

