/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.coverity.renderer;

import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.coverity.renderer.CoverityBlock;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.List;
import java.util.Map;

public class CoveritySourceItem
extends ViewSourceLinkItem {
    public CoveritySourceItem(AbstractRenderer renderer) {
        super(renderer);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        while (i < each.getStartLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        CoverityBlock block = (CoverityBlock)each;
                        String color = "#FF1A00";
                        while (i <= each.getEndLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title='").append(block.getMessage()).append("'>").append(block.getChecker()).append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        return super.rowsToBlocks(rows);
    }

    protected Block createLineBlock(ScriptEngine em, Map<String, Object> ec) {
        CoverityBlock block = new CoverityBlock();
        block.setStartLine((Integer)ec.get("mainEventLineNumber"));
        block.setEndLine((Integer)ec.get("mainEventLineNumber"));
        block.setMessage((String)ec.get("mainEventDescription"));
        block.setChecker((String)ec.get("checker"));
        block.setSubcategory((String)ec.get("subcategory"));
        block.setExtra((String)ec.get("extra"));
        return block;
    }
}

