/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.coverity.generator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.pmease.quickbuild.plugin.report.coverity.Coverity;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class CoverityIssueProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 1L;

    public CoverityIssueProcessor(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected AbstractRule createDefaultRule() {
        return null;
    }

    protected ResourceReader<?> createDefaultReader() {
        return null;
    }

    protected void processResource(GeneratorResource resource) {
        File input = resource.getFile();
        Preconditions.checkNotNull((Object)input);
        try {
            Coverity.Report report = Coverity.parse(input);
            DataReport issues = GeneratorContext.getContext().getDestReport();
            for (Coverity.IssueInfo each : report.getIssueInfo()) {
                List<Coverity.Issue> occurrences = each.getOccurrences();
                if (occurrences.isEmpty()) continue;
                for (Coverity.Issue issue : occurrences) {
                    DataRow issueRow = issues.addRow();
                    issueRow.setValue("mergeKey", (Object)each.getMergeKey());
                    issueRow.setValue("cid", (Object)each.getCid());
                    issueRow.setValue("checker", (Object)issue.getChecker());
                    issueRow.setValue("file", (Object)issue.getFile());
                    String func = issue.getFunction();
                    String packageName = ReportUtils.getPackageFromMethodName((String)func);
                    String className = ReportUtils.getClassFromMethodName((String)func);
                    String methodName = ReportUtils.getMethodFromMethodName((String)func);
                    issueRow.setValue("packageName", (Object)packageName);
                    issueRow.setValue("className", (Object)className);
                    issueRow.setValue("methodName", (Object)methodName);
                    issueRow.setValue("mainEventLineNumber", (Object)issue.getMainEventLineNumber());
                    issueRow.setValue("mainEventDescription", (Object)issue.getMainEventDescription());
                    issueRow.setValue("subcategory", (Object)issue.getSubcategory());
                    issueRow.setValue("extra", (Object)issue.getExtra());
                }
            }
        }
        catch (JsonParseException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

