/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.coverity.generator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.coverity.Coverity;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class CoverityIssueInfoProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 1L;

    public CoverityIssueInfoProcessor(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected AbstractRule createDefaultRule() {
        return null;
    }

    protected ResourceReader<?> createDefaultReader() {
        return null;
    }

    protected void processResource(GeneratorResource resource) {
        File input = resource.getFile();
        Preconditions.checkNotNull((Object)input);
        try {
            Coverity.Report report = Coverity.parse(input);
            DataReport issueInfo = GeneratorContext.getContext().getDestReport();
            String workspacePath = Context.getBuild().getConfiguration().getWorkspaceDir().getAbsolutePath();
            for (Coverity.IssueInfo each : report.getIssueInfo()) {
                HashMap rows = Maps.newHashMap();
                List<Coverity.Issue> occurrences = each.getOccurrences();
                for (Coverity.Issue issue : occurrences) {
                    DataRow row;
                    String file = issue.getFile();
                    if (rows.containsKey(file = ReportUtils.getRelativePath((String)file, (String)workspacePath))) {
                        row = (DataRow)rows.get(file);
                        row.setValue("occurrences", (Object)(row.getInt("occurrences") + 1));
                        continue;
                    }
                    row = issueInfo.addRow();
                    row.setValue("mergeKey", (Object)each.getMergeKey());
                    row.setValue("cid", (Object)each.getCid());
                    row.setValue("file", (Object)file);
                    if (each.getTriage() != null) {
                        row.setValue("classification", (Object)each.getTriage().getClassification());
                        row.setValue("owner", (Object)each.getTriage().getOwner());
                        row.setValue("action", (Object)each.getTriage().getAction());
                        row.setValue("fixTarget", (Object)each.getTriage().getFixTarget());
                        row.setValue("legacy", (Object)Boolean.valueOf(each.getTriage().getLegacy().toUpperCase()));
                        row.setValue("severity", (Object)each.getTriage().getSeverity());
                    }
                    row.setValue("occurrences", (Object)1);
                    rows.put(file, row);
                }
            }
        }
        catch (JsonParseException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

