/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.coverity.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.coverity.CoverityPlugin;
import com.pmease.quickbuild.plugin.report.coverity.renderer.CoverityStatsRenderer;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Coverity Stats", category={"Code Inspection Statistics"})
public class CoverityStatsGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;

    protected StatisticsRenderer createRenderer() {
        ReportCategory category = ReportHelper.getCategory(CoverityPlugin.class);
        CoverityStatsRenderer r = new CoverityStatsRenderer(category);
        r.setSimpleMode(true);
        return r;
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1)
    public List<String> getIndicators() {
        return super.getIndicators();
    }

    private static List<String> getAvailableIndicators() {
        return Lists.newArrayList((Object[])new String[]{"Detected Files", "Added Issues", "Not Fixed Issues", "Fixed Issues", "Occurrences"});
    }
}

