/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.coverity;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.report.coverity.CoverityPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysNewValue;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="Coverity Report", description="Publish Coverity JSON reports")
@ScriptApi(value="This step publishes the original Coverity JSON files.")
public class CoverityPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int occurrences;
    @XStreamOmitField
    private int added;
    @XStreamOmitField
    private int notFixed;
    @XStreamOmitField
    private int fixed;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(CoverityPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(GeneratorContext.getContext().getWorkingDir());
        try {
            db.open(DbStore.Mode.READ_WRITE, "CoverityPublisher::saveStatsReport");
            DataReport issueInfos = db.loadReport("issueinfo", new Filter[0]);
            DataReport summary = category.createReport("stats");
            DataRow row = summary.addRow();
            this.generateStatsReport(issueInfos, row);
            AlwaysNewValue instance = new AlwaysNewValue();
            db.persistRow(row, (MergeFunction)instance);
        }
        finally {
            db.close();
        }
    }

    private void generateStatsReport(DataReport issueInfos, DataRow destRow) {
        int occurrences = 0;
        int added = 0;
        int notFixed = 0;
        int fixed = 0;
        int files = 0;
        HashSet paths = Sets.newHashSet();
        for (DataRow each : issueInfos.getRows()) {
            String status;
            String file = each.getString("file");
            if (!paths.contains(file)) {
                ++files;
                paths.add(file);
            }
            if ("ADDED".equalsIgnoreCase(status = each.getString("status"))) {
                ++added;
            } else if ("NOT_FIXED".equalsIgnoreCase(status)) {
                ++notFixed;
            } else if ("FIXED".equalsIgnoreCase(status)) {
                ++fixed;
            }
            if ("FIXED".equalsIgnoreCase(status)) continue;
            occurrences += each.getInt("occurrences");
        }
        destRow.setValue("buildId", (Object)this.getBuild().getId());
        destRow.setValue("files", (Object)files);
        destRow.setValue("added", (Object)added);
        destRow.setValue("fixed", (Object)fixed);
        destRow.setValue("notFixed", (Object)notFixed);
        destRow.setValue("occurrences", (Object)occurrences);
    }

    protected String getStatsReportName() {
        return "stats";
    }

    public boolean isStepFailed() {
        DataReport statsReport = this.getStatsReport();
        if (statsReport.isEmpty()) {
            Context.getLogger().debug("No Coverity stats data found.");
        } else {
            DataRow row = statsReport.getRow(0);
            this.occurrences = row.getInt("occurrences");
            this.added = row.getInt("added");
            this.notFixed = row.getInt("notFixed");
            this.fixed = row.getInt("fixed");
        }
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=800, name="Files to Process", description="Specify JSON files to be processed. Path specified here is relative to source directory specified above, for example <b>reports/coverity/*.json</b> stands for all the files with <b>.json</b> suffix under the <b>reports/coverity</b> sub directory relative to the source directory. Refer to <a href=\"$docroot/File+Pattern+Reference\">File Pattern Reference</a> for details of valid file patterns.")
    @NotEmpty
    @ScriptApi(value="Get report files or patterns")
    @Scriptable
    public String getFilePattern() {
        return super.getFilePattern();
    }

    @ScriptApi(value="Returns total occurrences of all detected issues")
    public int getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(int occurrences) {
        this.occurrences = occurrences;
    }

    @ScriptApi(value="Returns the number of newly detected issues")
    public int getAdded() {
        return this.added;
    }

    public void setAdded(int added) {
        this.added = added;
    }

    @ScriptApi(value="Returns the number of not fixed issues")
    public int getNotFixed() {
        return this.notFixed;
    }

    public void setNotFixed(int notFixed) {
        this.notFixed = notFixed;
    }

    @ScriptApi(value="Returns the number of fixed issues")
    public int getFixed() {
        return this.fixed;
    }

    public void setFixed(int fixed) {
        this.fixed = fixed;
    }
}

