/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.coverity;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Coverity {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Report parse(File inputFile) throws JsonParseException, JsonMappingException, IOException {
        return (Report)objectMapper.readValue(inputFile, Report.class);
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class Report {
        private Header header = new Header();
        private AnalysisInfo analysisInfo = new AnalysisInfo();
        private List<IssueInfo> issueInfo = Lists.newArrayList();

        public Header getHeader() {
            return this.header;
        }

        public void setHeader(Header header) {
            this.header = header;
        }

        public AnalysisInfo getAnalysisInfo() {
            return this.analysisInfo;
        }

        public void setAnalysisInfo(AnalysisInfo analysisInfo) {
            this.analysisInfo = analysisInfo;
        }

        public List<IssueInfo> getIssueInfo() {
            return this.issueInfo;
        }

        public void setIssueInfo(List<IssueInfo> issueInfo) {
            this.issueInfo = issueInfo;
        }
    }

    public static class Triage {
        String classification;
        String owner;
        String action;
        String severity;
        String fixTarget;
        String legacy;

        public String getClassification() {
            return this.classification;
        }

        public void setClassification(String classification) {
            this.classification = classification;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public String getFixTarget() {
            return this.fixTarget;
        }

        public void setFixTarget(String fixTarget) {
            this.fixTarget = fixTarget;
        }

        public String getLegacy() {
            return this.legacy;
        }

        public void setLegacy(String legacy) {
            this.legacy = legacy;
        }
    }

    public static class Issue {
        String checker;
        String file;
        String function;
        String extra;
        String subcategory;
        String mainEventLineNumber;
        String mainEventDescription;

        public String getChecker() {
            return this.checker;
        }

        public void setChecker(String checker) {
            this.checker = checker;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public String getSubcategory() {
            return this.subcategory;
        }

        public void setSubcategory(String subcategory) {
            this.subcategory = subcategory;
        }

        public String getMainEventLineNumber() {
            return this.mainEventLineNumber;
        }

        public void setMainEventLineNumber(String mainEventLineNumber) {
            this.mainEventLineNumber = mainEventLineNumber;
        }

        public String getMainEventDescription() {
            return this.mainEventDescription;
        }

        public void setMainEventDescription(String mainEventDescription) {
            this.mainEventDescription = mainEventDescription;
        }
    }

    public static class IssueInfo {
        String cid;
        String mergeKey;
        List<Issue> occurrences = Lists.newArrayList();
        Triage triage = new Triage();

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }

        public String getMergeKey() {
            return this.mergeKey;
        }

        public void setMergeKey(String mergeKey) {
            this.mergeKey = mergeKey;
        }

        public List<Issue> getOccurrences() {
            return this.occurrences;
        }

        public void setOccurrences(List<Issue> occurrences) {
            this.occurrences = occurrences;
        }

        public Triage getTriage() {
            return this.triage;
        }

        public void setTriage(Triage triage) {
            this.triage = triage;
        }
    }

    public static class AnalysisInfo {
        String reportTimestamp;
        String command;
        String user;

        public String getReportTimestamp() {
            return this.reportTimestamp;
        }

        public void setReportTimestamp(String reportTimestamp) {
            this.reportTimestamp = reportTimestamp;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }

    public static class Header {
        String format;
        String version;

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

