/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.junit.renderer.TestDetailsColumn;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TestDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public TestDetailsColumnPanel(String id, IModel<ItemContext> model, TestDetailsColumn column) {
        super(id, model);
        DataRow row = this.getRow();
        int runs = (Integer)row.getValue("totalRuns");
        WebMarkupContainer runsContainer = new WebMarkupContainer("runsContainer");
        this.add(new Component[]{runsContainer});
        if (runs > 1) {
            runsContainer.add(new Component[]{new Label("totalRuns", String.valueOf(runs))});
            runsContainer.add(new Component[]{new Label("passedRuns", row.getValueAsString("passedRuns"))});
            runsContainer.add(new Component[]{new Label("failedRuns", row.getValueAsString("failedRuns"))});
        } else {
            runsContainer.setVisible(false);
        }
        String status = row.getValueAsString("status");
        status = ReportUtils.firstOf((String)status, (int)4);
        Label label = new Label("status", status);
        label.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)status.toLowerCase())), " ")});
        this.add(new Component[]{label});
        this.add(new Component[]{new Label("testName", row.getValueAsString("testName"))});
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
        this.add(new Component[]{new Label("committers", row.getValueAsString("committers"))});
        FilterLinkItem packageItem = column.getPackageFilterLink();
        this.add(new Component[]{packageItem.createComponent("packageName", model)});
        FilterLinkItem classItem = column.getClassFilterLink();
        this.add(new Component[]{classItem.createComponent("className", model)});
        Component testOutputLink = column.getTestOutputLinkItem().createComponent("testOutputLink", model);
        testOutputLink.setVisible(!Strings.isNullOrEmpty((String)row.getValueAsString("sysout")) || !Strings.isNullOrEmpty((String)row.getValueAsString("syserr")));
        this.add(new Component[]{testOutputLink});
        Component testsuiteOutputLink = column.getTestsuiteOutputLinkItem().createComponent("testsuiteOutputLink", model);
        testsuiteOutputLink.setVisible(row.getBoolean("hasSysout"));
        this.add(new Component[]{testsuiteOutputLink});
        this.add(new Component[]{new WebMarkupContainer("toTop").setVisible(!column.getRenderer().isInDropDown())});
        this.add(new Component[]{this.createLabel(row, "errorType")});
        this.add(new Component[]{this.createLabel(row, "errorMessage")});
        this.add(new Component[]{this.createLabel(row, "failureType")});
        this.add(new Component[]{this.createLabel(row, "failureMessage")});
        this.add(new Component[]{this.createLabel(row, "sysout")});
        this.add(new Component[]{this.createLabel(row, "syserr")});
        this.add(new Component[]{this.createLabel(row, "hostname")});
    }

    private Component createLabel(DataRow row, String id) {
        String value = row.getValueAsString(id);
        return new Label(id, ReportUtils.formatJUnitMessageAsHtml((String)value)).setEscapeModelStrings(false).setVisible(!StringUtils.isEmpty((String)value));
    }

    private DataRow getRow() {
        ItemContext context = (ItemContext)this.getDefaultModelObject();
        return context.getDataRow();
    }
}

