/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.renderer;

import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterDef;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleFilterDef;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.junit.renderer.SystemOutputLinkItem;
import com.pmease.quickbuild.plugin.report.junit.renderer.TestDetailsColumnPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class TestDetailsColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    private FilterLinkItem packageFilterLink = this.createFilterItem("packageName", "packageName");
    private FilterLinkItem classFilterLink;
    private SystemOutputLinkItem testsuiteOutputLinkItem;
    private SystemOutputLinkItem testOutputLinkItem;

    public TestDetailsColumn(AbstractRenderer renderer) {
        super(renderer);
        this.packageFilterLink.setDefaultValue("empty");
        this.classFilterLink = this.createFilterItem("packageName, className", "className");
        this.testsuiteOutputLinkItem = new SystemOutputLinkItem(this.getRenderer());
        AbstractRenderer suiteOutputRenderer = this.testsuiteOutputLinkItem.getPopupRenderer();
        ReportDataSource testsuiteDS = new ReportDataSource(this.getCategory());
        testsuiteDS.setFrom("testsuites");
        testsuiteDS.addFilter((FilterDef)new SimpleFilterDef("packageName", "packageName"));
        testsuiteDS.addFilter((FilterDef)new SimpleFilterDef("className", "className"));
        suiteOutputRenderer.setDataSource(testsuiteDS);
        this.testOutputLinkItem = new SystemOutputLinkItem(this.getRenderer());
        this.testOutputLinkItem.setImageUrl("report/console.gif");
        this.testOutputLinkItem.setTooltip("View system out/error of this test");
        AbstractRenderer testOutputRenderer = this.testOutputLinkItem.getPopupRenderer();
        ReportDataSource testDS = new ReportDataSource(this.getCategory());
        testDS.setFrom("tests");
        testDS.addFilter((FilterDef)new SimpleFilterDef("id", "id"));
        testOutputRenderer.setDataSource(testDS);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        return new TestDetailsColumnPanel(id, model, this);
    }

    public FilterLinkItem getPackageFilterLink() {
        return this.packageFilterLink;
    }

    public void setPackageFilterLink(FilterLinkItem packageFilterLink) {
        this.packageFilterLink = packageFilterLink;
    }

    public FilterLinkItem getClassFilterLink() {
        return this.classFilterLink;
    }

    public void setClassFilterLink(FilterLinkItem classFilterLink) {
        this.classFilterLink = classFilterLink;
    }

    public SystemOutputLinkItem getTestsuiteOutputLinkItem() {
        return this.testsuiteOutputLinkItem;
    }

    public void setTestsuiteOutputLinkItem(SystemOutputLinkItem testsuiteOutputLinkItem) {
        this.testsuiteOutputLinkItem = testsuiteOutputLinkItem;
    }

    public SystemOutputLinkItem getTestOutputLinkItem() {
        return this.testOutputLinkItem;
    }

    public void setTestOutputLinkItem(SystemOutputLinkItem testOutputLinkItem) {
        this.testOutputLinkItem = testOutputLinkItem;
    }
}

