/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.renderer;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQTabbedPanel;
import com.pmease.quickbuild.plugin.report.junit.renderer.SystemOutputRenderer;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class SystemOutputPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LINES = 50000;

    public SystemOutputPanel(String id, SystemOutputRenderer renderer, IModel<RendererContext> contextModel) {
        super(id, (AbstractRenderer)renderer, contextModel);
        String title;
        DataRow row = this.getRow();
        final String sysout = this.getSysOut();
        final String syserr = this.getSysErr();
        if (row == null) {
            title = "empty";
        } else {
            String packageName = row.getValueAsString("packageName", "empty");
            String className = row.getValueAsString("className", "empty");
            title = packageName + "." + className;
            if (row.getReport().getMeta().hasColumn("testName")) {
                title = row.getValueAsString("testName") + " <span class='light-text'>(" + title + ")</span>";
            }
        }
        this.add(new Component[]{new Label("title", title).setEscapeModelStrings(false)});
        LoadableDetachableModel<File> fileModel = new LoadableDetachableModel<File>(){
            private static final long serialVersionUID = 1L;

            protected File load() {
                File file = FileUtils.createTempFile((String)"sysout", (String)"");
                StringBuffer sb = new StringBuffer();
                if (sysout != null) {
                    sb.append("System Out\n\n");
                    sb.append(sysout);
                }
                if (syserr != null) {
                    sb.append("\n\nSystem Error\n\n");
                    sb.append(syserr);
                }
                FileUtils.writeFile((File)file, (String)sb.toString());
                return file;
            }
        };
        DownloadLink downloadLink = new DownloadLink("saveLink", (IModel)fileModel).setDeleteAfterDownload(true);
        this.add(new Component[]{downloadLink});
        ArrayList tabs = Lists.newArrayList();
        tabs.add(new ITab(){
            private static final long serialVersionUID = 1L;

            public IModel<String> getTitle() {
                return Model.of((Serializable)((Object)"System-out"));
            }

            public WebMarkupContainer getPanel(String containerId) {
                Fragment fragment = new Fragment(containerId, "outputFrag", (MarkupContainer)SystemOutputPanel.this);
                String[] outLines = StringUtils.split((String)sysout, (char)'\n');
                fragment.add(new Component[]{new WebMarkupContainer("noticeMessage").setVisible(outLines.length > 50000)});
                WebMarkupContainer span = new WebMarkupContainer("span");
                fragment.add(new Component[]{span});
                span.add(new Component[]{new Label("output", SystemOutputPanel.this.truncateLines(outLines, 50000)).setEscapeModelStrings(true)});
                return fragment;
            }

            public boolean isVisible() {
                return true;
            }
        });
        tabs.add(new ITab(){
            private static final long serialVersionUID = 1L;

            public IModel<String> getTitle() {
                return Model.of((Serializable)((Object)"System-err"));
            }

            public WebMarkupContainer getPanel(String containerId) {
                Fragment fragment = new Fragment(containerId, "outputFrag", (MarkupContainer)SystemOutputPanel.this);
                String[] outLines = StringUtils.split((String)syserr, (char)'\n');
                fragment.add(new Component[]{new WebMarkupContainer("noticeMessage").setVisible(outLines.length > 50000)});
                WebMarkupContainer span = new WebMarkupContainer("span");
                span.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"err-msg")), " ")});
                fragment.add(new Component[]{span});
                span.add(new Component[]{new Label("output", SystemOutputPanel.this.truncateLines(outLines, 50000)).setEscapeModelStrings(true)});
                return fragment;
            }

            public boolean isVisible() {
                return true;
            }
        });
        this.add(new Component[]{new JQTabbedPanel("outputs", (List)tabs)});
    }

    private DataRow getRow() {
        DataReport report = this.getDefaultReport();
        if (report == null || report.isEmpty()) {
            return null;
        }
        return report.getRow(0);
    }

    private String getSysOut() {
        DataRow row = this.getRow();
        if (row == null) {
            return "N/A";
        }
        String sysout = row.getValueAsString("sysout");
        if (Strings.isNullOrEmpty((String)sysout)) {
            return "N/A";
        }
        return sysout;
    }

    private String getSysErr() {
        DataRow row = this.getRow();
        if (row == null) {
            return "N/A";
        }
        String syserr = row.getValueAsString("syserr");
        if (Strings.isNullOrEmpty((String)syserr)) {
            return "N/A";
        }
        return syserr;
    }

    private String truncateLines(String[] lines, int n) {
        if (lines == null) {
            return null;
        }
        int start = lines.length - n;
        StringBuffer sb = new StringBuffer();
        if (start < 0) {
            start = 0;
        } else {
            sb.append("... ... ... \n\n");
        }
        for (int i = start; i < lines.length; ++i) {
            sb.append(lines[i]).append("\n");
        }
        return sb.toString();
    }
}

