/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.junit.JUnitHelper;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.util.EqualsHelper;

public class TestMetricsRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;
    private static final String[] columns = new String[]{"runs", "failures", "lastRunBuild", "latestBuilds", "latestStatuses", "latestDuration", "currentStatus", "averageDuration"};

    public TestMetricsRule(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void doExecute() {
        String currentStatus;
        GeneratorContext context = this.getContext();
        Long buildId = context.getCurrentBuild().getId();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        destRow.setValue("runs", (Object)(destRow.getInt("runs") + sourceRow.getInt("totalRuns")));
        destRow.setValue("failures", (Object)(destRow.getInt("failures") + sourceRow.getInt("failedRuns")));
        destRow.setValue("lastRunBuild", (Object)buildId);
        List latestBuilds = (List)destRow.getValue("latestBuilds");
        List latestStatuses = (List)destRow.getValue("latestStatuses");
        List latestDurations = (List)destRow.getValue("latestDurations");
        int index = -1;
        for (int i = 0; i < latestBuilds.size(); ++i) {
            Long b = (Long)latestBuilds.get(i);
            if (!EqualsHelper.equals((Object)buildId, (Object)b)) continue;
            index = i;
            break;
        }
        String status = sourceRow.getValueAsString("status");
        Long duration = sourceRow.getLong("duration");
        if (index == -1) {
            latestBuilds = ReportUtils.limitAddingValue((List)latestBuilds, (Object)buildId);
            latestStatuses = ReportUtils.limitAddingValue((List)latestStatuses, (Object)status);
            latestDurations = ReportUtils.limitAddingValue((List)latestDurations, (Object)duration);
            currentStatus = status;
        } else {
            String destStatus = (String)latestStatuses.get(index);
            Long destDuration = (Long)latestDurations.get(index);
            currentStatus = JUnitHelper.evaluateStatus(destStatus, status);
            latestStatuses.set(index, currentStatus);
            latestDurations.set(index, destDuration + duration);
        }
        destRow.setValue("latestBuilds", (Object)latestBuilds);
        destRow.setValue("latestStatuses", (Object)latestStatuses);
        destRow.setValue("latestDurations", (Object)latestDurations);
        destRow.setValue("currentStatus", (Object)currentStatus);
        destRow.setValue("averageDuration", (Object)ReportUtils.average(new ArrayList(latestDurations)));
    }

    protected String[] forColumns() {
        return columns;
    }
}

