/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.generator;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class PackageClassNameRule
extends XPathRule {
    private static final long serialVersionUID = 1L;
    @Alias(name="path")
    private String path;

    public PackageClassNameRule(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        Element element = context.getCurrentElement();
        String packageName = element.valueOf(this.path + "/@package");
        String className = element.valueOf(this.path + "/@name");
        if (StringUtils.isEmpty((String)packageName)) {
            String[] tokens = ReportUtils.splitClassName((String)className);
            packageName = tokens[0];
            className = tokens[1];
        }
        destRow.setValue("packageName", (Object)packageName);
        destRow.setValue("className", (Object)className);
    }

    protected String[] forColumns() {
        return new String[]{"packageName", "className"};
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

