/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.generator;

import com.google.common.collect.ImmutableSet;
import com.pmease.quickbuild.plugin.report.engine.generator.reader.XMLResourceReader;
import com.pmease.quickbuild.plugin.report.junit.PluginSetting;
import java.io.File;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.STAXEventReader;

public class JUnitXMLResourceReader
extends XMLResourceReader {
    static final Set<String> IGNORED = ImmutableSet.of((Object)"properties", (Object)"property");

    protected Document doRead(File xmlFile) {
        return super.doRead(xmlFile);
    }

    static class JUnitReader
    extends STAXEventReader {
        final DocumentFactory factory = DocumentFactory.getInstance();
        final int maxBytes = PluginSetting.getMaxBytes();

        JUnitReader() {
        }

        public Element readElement(XMLEventReader eventReader) throws XMLStreamException {
            String text;
            Element elem = super.readElement(eventReader);
            String name = elem.getName();
            if (IGNORED.contains(name)) {
                return this.factory.createElement(elem.getQName());
            }
            if ((elem.getName().equals("system-out") || elem.getName().equals("system-err")) && (text = elem.getText()) != null && text.length() > this.maxBytes) {
                text = text.substring(text.length() - this.maxBytes);
                elem.setText(text);
            }
            return elem;
        }
    }
}

