/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.junit.generator;

import com.pmease.quickbuild.plugin.report.engine.commons.DiffStatus;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;

public class DiffStatusRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;

    public DiffStatusRule(ReportCategory category) {
        super(category);
    }

    public Object evalValue() {
        DiffStatus s = this.getDiffStatus();
        return s.name();
    }

    private DiffStatus getDiffStatus() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        if (destRow == null) {
            return DiffStatus.REMOVED;
        }
        Status currentStatus = Status.valueOf(destRow.getString("status"));
        if (sourceRow == null) {
            if (currentStatus == Status.PASS || currentStatus == Status.SKIP) {
                return DiffStatus.ADDED;
            }
            return DiffStatus.NEW_FAILED;
        }
        Status previousStatus = Status.valueOf(sourceRow.getString("status"));
        if (previousStatus == currentStatus) {
            if (currentStatus == Status.PASS || currentStatus == Status.SKIP) {
                return DiffStatus.UNCHANGED;
            }
            return DiffStatus.NOT_FIXED;
        }
        if (currentStatus == Status.PASS) {
            return DiffStatus.FIXED;
        }
        if (currentStatus == Status.SKIP) {
            if (previousStatus == Status.ERROR || previousStatus == Status.FAILURE) {
                return DiffStatus.NOT_FIXED;
            }
            return DiffStatus.UNCHANGED;
        }
        if (previousStatus == Status.PASS || previousStatus == Status.SKIP) {
            return DiffStatus.NEW_FAILED;
        }
        return DiffStatus.NOT_FIXED;
    }

    static enum Status {
        PASS,
        SKIP,
        FAILURE,
        ERROR;

    }
}

