/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce.shelvecondition;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.scm.perforce.shelvecondition.ShelveCondition;
import com.pmease.quickbuild.plugin.scm.perforce.shelvecondition.ShelveConditionCriteria;
import com.pmease.quickbuild.repositorysupport.Repository;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="If one of specified criterias is satisfied", order=70)
public class OrShelveCondition
implements ShelveCondition {
    private static final long serialVersionUID = 1L;
    private List<ShelveConditionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<ShelveConditionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<ShelveConditionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean satisfied(Repository<?> repository) {
        for (ShelveConditionCriteria each : this.getCriterias()) {
            if (!each.getCriteria().satisfied(repository)) continue;
            return true;
        }
        return false;
    }
}

