/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.perforce.Mapping;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpec;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpecProvider;
import com.pmease.quickbuild.util.StringUtils;
import java.io.OutputStream;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=200, name="Use specification of an existing client")
@ScriptApi(value="Derive client spec based on specified template client.")
public class TemplateStaticSpecProvider
implements StaticSpecProvider {
    private PerforceRepository repository;
    private String clientName;

    public TemplateStaticSpecProvider(PerforceRepository repository) {
        this.repository = repository;
    }

    @Editable(order=100, name="Existing Client Name", description="Specify name of an existing Perforce client whose specification will be used as template for the client created by QuickBuild at build time. The newly created client will have the same specification as the client specified here, except that:<ul><li>The host name is set to host name of the node running the checkout step.</li><li>The root directory is set to value of the <b>root directory</b> property defined below.</li><li>The unlocked option will always be used.</li></ul>")
    @NotEmpty
    @ScriptApi(value="Get name of the client used as template.")
    @Scriptable
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public StaticSpec getStaticSpec() {
        Commandline cmdline = this.repository.buildP4Cmd(this.repository.getUserName(), this.repository.getPassword());
        cmdline.addArgValue("clients");
        final boolean[] found = new boolean[]{false};
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.startsWith("Client " + TemplateStaticSpecProvider.this.getClientName() + " ")) {
                    found[0] = true;
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        if (!found[0]) {
            throw new QuickbuildException("Template perforce client '" + this.getClientName() + "' does not exist.");
        }
        cmdline = this.repository.buildP4Cmd(this.repository.getUserName(), this.repository.getPassword());
        cmdline.addArgLine("-c " + this.getClientName() + " client -o");
        final String[] view = new String[]{null};
        final String[] description = new String[]{null};
        final String[] owner = new String[]{null};
        final String[] host = new String[]{null};
        final String[] root = new String[]{null};
        final String[] options = new String[]{null};
        final String[] submitOptions = new String[]{null};
        final String[] lineEnd = new String[]{null};
        final String[] serverId = new String[]{null};
        cmdline.execute((OutputStream)new LineConsumer(){
            private boolean inDescBlock = false;
            private boolean inViewBlock = false;

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (!line.startsWith("#")) {
                    if (line.length() == 0) {
                        this.inViewBlock = false;
                        this.inDescBlock = false;
                    } else if (this.inDescBlock) {
                        description[0] = description[0] == null ? line.trim() : description[0] + "\n" + line.trim();
                    } else if (this.inViewBlock) {
                        view[0] = view[0] == null ? line.trim() : view[0] + "\n" + line.trim();
                    } else if (line.startsWith("Owner:")) {
                        owner[0] = line.substring(6);
                    } else if (line.startsWith("Host:")) {
                        host[0] = line.substring(5).trim();
                    } else if (line.startsWith("Root:")) {
                        root[0] = line.substring(5).trim();
                    } else if (line.startsWith("Options:")) {
                        options[0] = line.substring(8).trim();
                    } else if (line.startsWith("SubmitOptions:")) {
                        submitOptions[0] = line.substring(14).trim();
                    } else if (line.startsWith("LineEnd:")) {
                        lineEnd[0] = line.substring(8).trim();
                    } else if (line.startsWith("ServerID:")) {
                        serverId[0] = line.substring("ServerID:".length()).trim();
                    } else if (line.startsWith("Description:")) {
                        this.inDescBlock = true;
                    } else if (line.startsWith("View:")) {
                        this.inViewBlock = true;
                    }
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        StaticSpec spec = new StaticSpec();
        spec.setLineEnd(lineEnd[0]);
        if (serverId[0] != null) {
            spec.setServerId(serverId[0]);
        }
        if (!options[0].contains("unlocked")) {
            options[0] = StringUtils.replace((String)options[0], (String)"locked", (String)"unlocked");
        }
        spec.setOptions(options[0]);
        spec.setMappings(Mapping.parseView(this.repository, view[0]));
        spec.setSubmitOptions(submitOptions[0]);
        return spec;
    }

    @ScriptApi(value="Get repository object.")
    public PerforceRepository getRepository() {
        return this.repository;
    }
}

