/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.perforce.Mapping;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpec;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpecProvider;
import com.pmease.quickbuild.util.StringUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=300, name="Create client based on specified stream")
@ScriptApi(value="Provide client spec by stream.")
public class StreamStaticSpecProvider
implements StaticSpecProvider {
    private PerforceRepository repository;
    private String stream;
    private List<String> options = new ArrayList<String>();
    private String submitOptions = "submitunchanged";
    private String lineEnd = "local";
    private String serverId;

    public StreamStaticSpecProvider(PerforceRepository repository) {
        this.repository = repository;
    }

    @Editable(order=100, name="Stream", description="Specify stream to associate with the client. For instance: //streamsDepot/mainline")
    @NotEmpty
    @ScriptApi(value="Get stream associated with the client.")
    @Scriptable
    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    @Editable(order=150)
    @Choices(value={"submitunchanged", "submitunchanged+reopen", "revertunchanged", "revertunchanged+reopen", "leaveunchanged", "leaveunchanged+reopen"})
    @NotNull
    @ScriptApi(value="Get submit options")
    public String getSubmitOptions() {
        return this.submitOptions;
    }

    public void setSubmitOptions(String submitOptions) {
        this.submitOptions = submitOptions;
    }

    @Editable(order=200)
    @Choices(value={"compress", "modtime", "rmdir", "clobber", "allwrite"})
    @ScriptApi(value="Get client options.")
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    @Editable(order=300)
    @Choices(value={"local", "unix", "mac", "win", "share"})
    @NotNull
    @ScriptApi(value="Get line end mode.")
    @Scriptable
    public String getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
    }

    @Editable(order=400, name="Server ID")
    @ScriptApi(value="Get ServerID property.")
    @Scriptable
    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    @ScriptApi(value="Get client spec.")
    public StaticSpec getStaticSpec() {
        StaticSpec spec = new StaticSpec();
        spec.setLineEnd(this.getLineEnd());
        if (this.getServerId() != null) {
            spec.setServerId(this.getServerId());
        }
        spec.setOptions(StringUtils.join(this.getOptions().iterator(), (String)" "));
        spec.setSubmitOptions(this.getSubmitOptions());
        spec.setStream(this.getStream());
        if (this.repository.isClientSynced()) {
            Commandline cmdline = this.repository.buildP4Cmd(this.repository.getUserName(), this.repository.getPassword());
            cmdline.addArgLine("-c " + this.repository.getClientName() + " client -o");
            final String[] view = new String[]{null};
            final String[] description = new String[]{null};
            final String[] owner = new String[]{null};
            final String[] host = new String[]{null};
            final String[] root = new String[]{null};
            final String[] options = new String[]{null};
            final String[] submitOptions = new String[]{null};
            final String[] lineEnd = new String[]{null};
            final String[] serverId = new String[]{null};
            cmdline.execute((OutputStream)new LineConsumer(){
                private boolean inDescBlock = false;
                private boolean inViewBlock = false;

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (!line.startsWith("#")) {
                        if (line.length() == 0) {
                            this.inViewBlock = false;
                            this.inDescBlock = false;
                        } else if (this.inDescBlock) {
                            description[0] = description[0] == null ? line.trim() : description[0] + "\n" + line.trim();
                        } else if (this.inViewBlock) {
                            view[0] = view[0] == null ? line.trim() : view[0] + "\n" + line.trim();
                        } else if (line.startsWith("Owner:")) {
                            owner[0] = line.substring(6);
                        } else if (line.startsWith("Host:")) {
                            host[0] = line.substring(5).trim();
                        } else if (line.startsWith("Root:")) {
                            root[0] = line.substring(5).trim();
                        } else if (line.startsWith("Options:")) {
                            options[0] = line.substring(8).trim();
                        } else if (line.startsWith("SubmitOptions:")) {
                            submitOptions[0] = line.substring(14).trim();
                        } else if (line.startsWith("LineEnd:")) {
                            lineEnd[0] = line.substring(8).trim();
                        } else if (line.startsWith("ServerID:")) {
                            serverId[0] = line.substring("ServerID:".length()).trim();
                        } else if (line.startsWith("Description:")) {
                            this.inDescBlock = true;
                        } else if (line.startsWith("View:")) {
                            this.inViewBlock = true;
                        }
                    }
                }
            }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            spec.setMappings(Mapping.parseView(this.repository, view[0]));
        } else {
            spec.setMappings(new ArrayList<Mapping>());
        }
        return spec;
    }

    @ScriptApi(value="Get repository object.")
    public PerforceRepository getRepository() {
        return this.repository;
    }
}

